% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_nested.R
\name{guide_axis_nested}
\alias{guide_axis_nested}
\title{Nested axis guide}
\usage{
guide_axis_nested(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  position = waiver(),
  delim = waiver(),
  inv = FALSE,
  trunc_lower = NULL,
  trunc_upper = NULL,
  colour = NULL,
  color = NULL,
  extend = 0.5
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}

\item{delim}{A \code{character} of length 1 to tell \code{strsplit} how
hierarchies should be broken up. Internally defaults to \code{"."} to match
\code{interaction}'s default delimiter.}

\item{inv}{A \code{logical(1)} which if \code{TRUE}, flips the grouping order. If
\code{FALSE} (default), the grouping order is as-is.}

\item{trunc_lower, trunc_upper}{The lower and upper range of the truncated
axis:
\itemize{
\item \code{NULL} to not perform any truncation.
\item A \code{function} that takes the break positions as input and returns the lower
or upper boundary. Note that also for discrete scales, positions are the
mapped positions as \code{numeric}.
\item A \code{numeric} value in data units for the lower and upper boundaries.
\item A \code{unit} object.
}}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{extend}{A \code{numeric} of length 1 indicating how much to extend
nesting lines relative to the smallest difference in break positions.}
}
\value{
A \emph{axis_nested} guide class object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
Discrete position scales containing interacting factors can be visualised
more clearly with a nested axis guide. Nested axis guides separate labels
based on a delimiter and groups identical later labels, indicating the
grouping with a line spanning the earlier labels.
The function is questioned due to
a possible migration of guide functions after ggplot2 releases a new guide
system.
}
\details{
The guide itself makes no effort to group and order labels. To get
nice groupings, consider re-ordering the levels of factor variables, or try
setting the 'breaks' argument of a scale appropriately.
}
\section{Theme elements}{

This axis guide uses the following the theme elements:

\describe{
\item{\code{\link[=theme_extensions]{ggh4x.axis.nestline.x/y}}}{
An \code{\link[=element_line]{element_line()}} object to alter the display of the line
separating different layers of labels.
}
\item{\code{\link[=theme_extensions]{ggh4x.axis.nesttext.x/y}}}{
An \code{\link[=element_text]{element_text()}} object to differentiate text higher up in the
hierarchy, from the text closest to the axis line.
}
}
}

\examples{
# The defaults are suited for interaction variables
ggplot(mpg, aes(interaction(cyl, class), hwy)) +
  geom_boxplot() +
  scale_x_discrete(guide = "axis_nested")

# Control where labels are cut with the delim argument
ggplot(mpg, aes(interaction(cyl, class, sep = "~!~"), hwy)) +
  geom_boxplot() +
  scale_x_discrete(guide = guide_axis_nested(delim = "!"))

# The nesting lines inherit looks from axis ticks
ggplot(mpg, aes(interaction(cyl, class), hwy)) +
  geom_boxplot() +
  scale_x_discrete(guide = "axis_nested") +
  theme(axis.ticks = element_line(colour = "red"))

# The looks can be controlled independently by setting `ggh4x.axis.nestline`
ggplot(mpg, aes(interaction(cyl, class), hwy)) +
  geom_boxplot() +
  scale_x_discrete(guide = "axis_nested") +
  theme(ggh4x.axis.nestline = element_line(linetype = 2))
}
\seealso{
\code{\link[ggplot2:guide_axis]{ggplot2::guide_axis()}} for the classic axis
documentation. \cr \code{\link[=weave_factors]{weave_factors()}} for an alternative to
\code{interaction()}.

Other axis-guides: 
\code{\link{guide_axis_logticks}()},
\code{\link{guide_axis_manual}()},
\code{\link{guide_axis_minor}()},
\code{\link{guide_axis_scalebar}()},
\code{\link{guide_axis_truncated}()}
}
\concept{axis-guides}
