% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_half_dotplot.R
\name{geom_half_dotplot}
\alias{geom_half_dotplot}
\title{Half dot plot with sensible parameter settings.}
\usage{
geom_half_dotplot(mapping = NULL, data = NULL, position = "dodge",
  ..., binwidth = NULL, binaxis = "y", method = "dotdensity",
  binpositions = "bygroup", stackdir = "up", stackratio = 1,
  dotsize = 1, stackgroups = FALSE, origin = NULL, right = TRUE,
  width = NULL, drop = FALSE, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{binwidth}{When \code{method} is "dotdensity", this specifies maximum bin
width. When \code{method} is "histodot", this specifies bin width.
Defaults to 1/30 of the range of the data}

\item{binaxis}{The axis to bin along, "x" (default) or "y"}

\item{method}{"dotdensity" (default) for dot-density binning, or
"histodot" for fixed bin widths (like stat_bin)}

\item{binpositions}{When \code{method} is "dotdensity", "bygroup" (default)
determines positions of the bins for each group separately. "all" determines
positions of the bins with all the data taken together; this is used for
aligning dot stacks across multiple groups.}

\item{stackdir}{Which direction to stack the dots. "up" (default) places the half-dotplot on the right side. "down" on the left side.}

\item{stackratio}{how close to stack the dots. Default is 1, where dots
just touch. Use smaller values for closer, overlapping dots.}

\item{dotsize}{The diameter of the dots relative to \code{binwidth}, default 1.}

\item{stackgroups}{should dots be stacked across groups? This has the effect
that \code{position = "stack"} should have, but can't (because this geom has
some odd properties).}

\item{origin}{When \code{method} is "histodot", origin of first bin}

\item{right}{When \code{method} is "histodot", should intervals be closed
on the right (a, b], or not [a, b)}

\item{width}{When \code{binaxis} is "y", the spacing of the dot stacks
for dodging.}

\item{drop}{If TRUE, remove all bins with zero counts}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
In a dot plot, the width of a dot corresponds to the bin width
(or maximum width, depending on the binning algorithm), and dots are
stacked, with each dot representing one observation.
}
\details{
There are two basic approaches: \emph{dot-density} and \emph{histodot}.
With dot-density binning, the bin positions are determined by the data and
`binwidth`, which is the maximum width of each bin. See Wilkinson
(1999) for details on the dot-density binning algorithm. With histodot
binning, the bins have fixed positions and fixed widths, much like a
histogram.

When binning along the x axis and stacking along the y axis, the numbers on
y axis are not meaningful, due to technical limitations of ggplot2. You can
hide the y axis, as in one of the examples, or manually scale it
to match the number of dots.
}
\section{Computed variables}{

\describe{
  \item{x}{center of each bin, if binaxis is "x"}
  \item{y}{center of each bin, if binaxis is "x"}
  \item{binwidth}{max width of each bin if method is "dotdensity";
    width of each bin if method is "histodot"}
  \item{count}{number of points in bin}
  \item{ncount}{count, scaled to maximum of 1}
  \item{density}{density of points in bin, scaled to integrate to 1,
    if method is "histodot"}
  \item{ndensity}{density, scaled to maximum of 1, if method is "histodot"}
}
}

\examples{
ggplot(iris, aes(x = Species, y = Petal.Width, fill = Species)) + 
  geom_half_dotplot(stackratio = .5, method = "histodot") 
}
\references{
Wilkinson, L. (1999) Dot plots. The American Statistician,
   53(3), 276-281.
}
