% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_density.R
\name{ggs_density}
\alias{ggs_density}
\title{Density plots of the chains}
\usage{
ggs_density(D, family = NA, rug = FALSE, hpd = FALSE, greek = FALSE)
}
\arguments{
\item{D}{Data frame whith the simulations.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{rug}{Logical indicating whether a rug must be added to the plot. It is FALSE by default, since in large chains it may use lot of resources and it is not central to the plot.}

\item{hpd}{Logical indicating whether HPD intervals (using the defaults from ci()) must be added to the plot. It is FALSE by default.}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}
}
\value{
A \code{ggplot} object.
}
\description{
Density plots with the parameter distribution. For multiple chains, use colours to differentiate the distributions.
}
\examples{
data(linear)
ggs_density(ggs(s))
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09
}
