% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_highlight_government.R
\name{geom_highlight_government}
\alias{geom_highlight_government}
\title{Highlight governments or parties in control of the legislature by encircling the points.}
\source{
https://yutani.rbind.io/post/2017-11-07-ggplot-add/
}
\usage{
geom_highlight_government(expr, colour, size, shape, stroke)
}
\arguments{
\item{expr}{Expr refers to the observation that you wish to highlight.}

\item{colour}{Colour of the highlight}

\item{size}{Size of highlighter}

\item{shape}{Shape of highlight}

\item{stroke}{Size of stroke shape}
}
\description{
Highlight governments or parties in control of the legislature by encircling the points.
}
\examples{
data <- election_data[
  election_data$country == "USA" &
  election_data$house == "Representatives" &
  election_data$year == "2016",
]
usa_data <- parliament_data(
  election_data = data,
  type = "semicircle",
  party_seats = data$seats,
  parl_rows = 8
)
ggplot2::ggplot(usa_data, ggplot2::aes(x, y, colour = party_long)) +
  geom_parliament_seats() +
  geom_highlight_government(government == 1) +
  theme_ggparliament()
}
\author{
Zoe Meers
}
