% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparty.R
\name{geom_edge_label}
\alias{geom_edge_label}
\title{Draw edge labels}
\usage{
geom_edge_label(mapping = NULL, nudge_x = 0, nudge_y = 0,
  ids = NULL, shift = 0.5, label.size = 0,
  splitlevels = seq_len(100), max_length = NULL, parse_all = FALSE,
  parse = TRUE, ...)
}
\arguments{
\item{mapping}{Mapping of \code{label} label defaults to \strong{breaks_label}. Other
mappings can be added here as \code{aes()}.}

\item{nudge_x, nudge_y}{Nudge label.}

\item{ids}{Choose which splitbreaks to label by their children's ids.}

\item{shift}{Value in (0,1). Moves label along corresponding edge.}

\item{label.size}{See \code{\link[=geom_label]{geom_label()}}.}

\item{splitlevels}{Which levels of split to plot. This may be useful in the
presence of many factor levels for one split break.}

\item{max_length}{If provided \strong{breaks_label} levels will be truncated to the specified length.}

\item{parse_all}{Defaults to \code{FALSE}, in which case everything but the inequality
signs of \strong{breaks_label} are deparsed. If \code{TRUE} complete \strong{breaks_label} are parsed.}

\item{parse}{Needs to be true in order to parse inequality signs of \strong{breaks_label}.}

\item{...}{Additional arguments for \code{\link[=geom_label]{geom_label()}}.}
}
\description{
Label edges with corresponding split breaks
}
\examples{
library(ggparty)
data("WeatherPlay", package = "partykit")
sp_o <- partysplit(1L, index = 1:3)
sp_h <- partysplit(3L, breaks = 75)
sp_w <- partysplit(4L, index = 1:2)
pn <- partynode(1L, split = sp_o, kids = list(
  partynode(2L, split = sp_h, kids = list(
    partynode(3L, info = "yes"),
    partynode(4L, info = "no"))),
  partynode(5L, info = "yes"),
  partynode(6L, split = sp_w, kids = list(
    partynode(7L, info = "yes"),
    partynode(8L, info = "no")))))
py <- party(pn, WeatherPlay)

ggparty(py) +
  geom_edge() +
  geom_edge_label() +
  geom_node_label(aes(label = splitvar),
                  ids = "inner") +
  geom_node_label(aes(label = info),
                  ids = "terminal")
}
\seealso{
\code{\link[=ggparty]{ggparty()}}
}
