% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_label.R
\name{geom_node_label}
\alias{geom_node_label}
\alias{geom_node_info}
\alias{geom_node_splitvar}
\title{Draw (multi-line) labels at nodes}
\usage{
geom_node_label(mapping = NULL, data = NULL, line_list = NULL,
  line_gpar = NULL, ids = NULL, position = "identity", ...,
  parse = FALSE, nudge_x = 0, nudge_y = 0,
  label.padding = unit(0.25, "lines"), label.r = unit(0.15, "lines"),
  label.size = 0.25, label.col = NULL, label.fill = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)

geom_node_info(mapping = NULL, nudge_x = 0, nudge_y = 0,
  ids = NULL, label.padding = unit(0.5, "lines"), ...)

geom_node_splitvar(mapping = NULL, nudge_x = 0, nudge_y = 0,
  label.padding = unit(0.5, "lines"), ids = NULL, ...)
}
\arguments{
\item{mapping}{\code{x} and \code{y} are mapped per default to the node's coordinates. If
you don't want to set line specific graphical parameters, you can also map
\code{label} here. Otherwise set \code{labels} in \code{line_list}.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{line_list}{Use this only if you want a multi-line label with the
possibility to override the aesthetics mapping for each line specifically
with fixed graphical parameters. In this case, don't map anything to
\code{label} in the \code{aes()} supplied to \code{mapping}
, but instead pass here a list of \code{aes()} with the \strong{only} mapped variable
in each
being \code{label}.
Other aesthetic mappings still can be passed to \code{mapping} and will apply to
all lines and the border, unless overwritten by \code{line_gpar}.
The order of the list represents the order of the plotted lines.}

\item{line_gpar}{List of lists containing line-specific graphical parameters.
Only use in
conjunction with \code{line_list}. Has to contain the same number of lists as are
\code{aes()} in \code{line_list}. First list applies to first line, and so on.}

\item{ids}{Select for which nodes to draw a label. Can be \code{"inner"}, \code{"terminal"},
\code{"all"} or \code{numeric} vector of ids.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Additional arguments to layer.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions. Can also
be specified per line via \code{line_gpar}.}

\item{nudge_x, nudge_y}{Adjust position of label.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{label.col}{Border colour.}

\item{label.fill}{Background colour.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
\code{geom_node_splitvar()} and \code{geom_node_info()} are simplified versions of
\code{geom_node_label()} with the respective defaults to either label the split variables
for all inner nodes or the info for all terminal nodes.
}
\details{
\code{geom_node_label()} is a modified version of \code{\link[ggplot2:geom_label]{ggplot2::geom_label()}}. This
modification allows for labels with multiple lines and line specific graphical
parameters.
}
\examples{
library(ggparty)
data("WeatherPlay", package = "partykit")
sp_o <- partysplit(1L, index = 1:3)
sp_h <- partysplit(3L, breaks = 75)
sp_w <- partysplit(4L, index = 1:2)
pn <- partynode(1L, split = sp_o, kids = list(
  partynode(2L, split = sp_h, kids = list(
    partynode(3L, info = "yes"),
    partynode(4L, info = "no"))),
  partynode(5L, info = "yes"),
  partynode(6L, split = sp_w, kids = list(
    partynode(7L, info = "yes"),
    partynode(8L, info = "no")))))
py <- party(pn, WeatherPlay)

ggparty(py) +
  geom_edge() +
  geom_edge_label() +
  geom_node_label(aes(label = splitvar),
                  ids = "inner") +
  geom_node_label(aes(label = info),
                  ids = "terminal")

######################################

data("TeachingRatings", package = "AER")
tr <- subset(TeachingRatings, credits == "more")

tr_tree <- lmtree(eval ~ beauty | minority + age + gender + division + native +
                   tenure, data = tr, weights = students, caseweights = FALSE)

data("TeachingRatings", package = "AER")
tr <- subset(TeachingRatings, credits == "more")

tr_tree <- lmtree(eval ~ beauty | minority + age + gender + division + native +
                    tenure, data = tr, weights = students, caseweights = FALSE)

ggparty(tr_tree,
        terminal_space = 0.5,
        add_vars = list(p.value = "$node$info$p.value")) +
  geom_edge(size = 1.5) +
  geom_edge_label(colour = "grey", size = 6) +
  geom_node_plot(gglist = list(geom_point(aes(x = beauty,
                                              y = eval,
                                              col = tenure,
                                              shape = minority),
                                          alpha = 0.8),
                               theme_bw(base_size = 15)),
                 scales = "fixed",
                 id = "terminal",
                 shared_axis_labels = TRUE,
                 shared_legend = TRUE,
                 legend_separator = TRUE,
                 predict = "beauty",
                 predict_gpar = list(col = "blue",
                                    size = 1.2)
  ) +
  geom_node_label(aes(col = splitvar),
                  line_list = list(aes(label = paste("Node", id)),
                                   aes(label = splitvar),
                                   aes(label = paste("p =", formatC(p.value,
                                    format = "e", digits = 2)))),
                  line_gpar = list(list(size = 12, col = "black", fontface = "bold"),
                                   list(size = 20),
                                   list(size = 12)),
                  ids = "inner") +
  geom_node_label(aes(label = paste0("Node ", id, ", N = ", nodesize)),
                  fontface = "bold",
                  ids = "terminal",
                  size = 5,
                  nudge_y = 0.01) +
  theme(legend.position = "none")
}
\seealso{
\code{\link[=ggparty]{ggparty()}}
}
