% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-grey.R, R/zxx.r
\name{scale_pattern_colour_grey}
\alias{scale_pattern_colour_grey}
\alias{scale_pattern_fill_grey}
\alias{scale_pattern_fill2_grey}
\alias{scale_pattern_color_grey}
\title{Sequential grey colour scales}
\usage{
scale_pattern_colour_grey(
  ...,
  start = 0.2,
  end = 0.8,
  na.value = "red",
  aesthetics = "pattern_colour"
)

scale_pattern_fill_grey(
  ...,
  start = 0.2,
  end = 0.8,
  na.value = "red",
  aesthetics = "pattern_fill"
)

scale_pattern_fill2_grey(
  ...,
  start = 0.2,
  end = 0.8,
  na.value = "red",
  aesthetics = "pattern_fill2"
)
}
\arguments{
\item{..., start, end, na.value, aesthetics}{See
\code{ggplot2::scale_colour_grey} for more information}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
Based on \code{\link[=gray.colors]{gray.colors()}}. This is black and white equivalent
of \code{\link[=scale_pattern_colour_gradient]{scale_pattern_colour_gradient()}}.
}
\examples{
  if (require("ggplot2")) {
    df <- data.frame(level = c("a", "b", "c", "d"),
                     outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_grey()
    plot(gg)
  }
}
