% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_gsea.R
\name{visualize_gsea}
\alias{visualize_gsea}
\title{Visualize GSEA results}
\usage{
visualize_gsea(
  gsea_results,
  plot_type = "enrichment_plot",
  n_pathways = 20,
  sort_by = "p.adjust",
  colors = NULL,
  abundance = NULL,
  metadata = NULL,
  group = NULL,
  network_params = list(),
  heatmap_params = list()
)
}
\arguments{
\item{gsea_results}{A data frame containing GSEA results from the pathway_gsea function}

\item{plot_type}{A character string specifying the visualization type: "enrichment_plot", "dotplot", "barplot", "network", or "heatmap"}

\item{n_pathways}{An integer specifying the number of pathways to display}

\item{sort_by}{A character string specifying the sorting criterion: "NES", "pvalue", or "p.adjust"}

\item{colors}{A vector of colors for the visualization}

\item{abundance}{A data frame containing the original abundance data (required for heatmap visualization)}

\item{metadata}{A data frame containing sample metadata (required for heatmap visualization)}

\item{group}{A character string specifying the column name in metadata that contains the grouping variable (required for heatmap visualization)}

\item{network_params}{A list of parameters for network visualization}

\item{heatmap_params}{A list of parameters for heatmap visualization}
}
\value{
A ggplot2 object or ComplexHeatmap object
}
\description{
This function creates various visualizations for Gene Set Enrichment Analysis (GSEA) results.
}
\examples{
\dontrun{
# Load example data
data(ko_abundance)
data(metadata)

# Prepare abundance data
abundance_data <- as.data.frame(ko_abundance)
rownames(abundance_data) <- abundance_data[, "#NAME"]
abundance_data <- abundance_data[, -1]

# Run GSEA analysis
gsea_results <- pathway_gsea(
  abundance = abundance_data,
  metadata = metadata,
  group = "Environment",
  pathway_type = "KEGG",
  method = "fgsea"
)

# Create enrichment plot
visualize_gsea(gsea_results, plot_type = "enrichment_plot", n_pathways = 10)

# Create dotplot
visualize_gsea(gsea_results, plot_type = "dotplot", n_pathways = 20)

# Create barplot
visualize_gsea(gsea_results, plot_type = "barplot", n_pathways = 15)

# Create network plot
visualize_gsea(gsea_results, plot_type = "network", n_pathways = 15)

# Create heatmap
visualize_gsea(
  gsea_results,
  plot_type = "heatmap",
  n_pathways = 15,
  abundance = abundance_data,
  metadata = metadata,
  group = "Environment"
)
}
}
