% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_gsea_daa.R
\name{compare_gsea_daa}
\alias{compare_gsea_daa}
\title{Compare GSEA and DAA results}
\usage{
compare_gsea_daa(
  gsea_results,
  daa_results,
  plot_type = "venn",
  p_threshold = 0.05
)
}
\arguments{
\item{gsea_results}{A data frame containing GSEA results from the pathway_gsea function}

\item{daa_results}{A data frame containing DAA results from the pathway_daa function}

\item{plot_type}{A character string specifying the visualization type: "venn", "upset", "scatter", or "heatmap"}

\item{p_threshold}{A numeric value specifying the significance threshold}
}
\value{
A ggplot2 object or a list containing the plot and comparison results
}
\description{
This function compares the results from Gene Set Enrichment Analysis (GSEA) and
Differential Abundance Analysis (DAA) to identify similarities and differences.
}
\examples{
\dontrun{
# Load example data
data(ko_abundance)
data(metadata)

# Prepare abundance data
abundance_data <- as.data.frame(ko_abundance)
rownames(abundance_data) <- abundance_data[, "#NAME"]
abundance_data <- abundance_data[, -1]

# Run GSEA analysis
gsea_results <- pathway_gsea(
  abundance = abundance_data,
  metadata = metadata,
  group = "Environment",
  pathway_type = "KEGG",
  method = "fgsea"
)

# Run DAA analysis
daa_results <- pathway_daa(
  abundance = abundance_data,
  metadata = metadata,
  group = "Environment"
)

# Compare results
comparison <- compare_gsea_daa(
  gsea_results = gsea_results,
  daa_results = daa_results,
  plot_type = "venn"
)
}
}
