% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.r
\name{labs}
\alias{labs}
\alias{xlab}
\alias{ylab}
\alias{ggtitle}
\title{Modify axis, legend, and plot labels}
\usage{
labs(..., title = waiver(), subtitle = waiver(), caption = waiver(),
  tag = waiver())

xlab(label)

ylab(label)

ggtitle(label, subtitle = waiver())
}
\arguments{
\item{...}{A list of new name-value pairs. The name should be an aesthetic.}

\item{title}{The text for the title.}

\item{subtitle}{The text for the subtitle for the plot which will be
displayed below the title.}

\item{caption}{The text for the caption which will be displayed in the
bottom-right of the plot by default.}

\item{tag}{The text for the tag label which will be displayed at the
top-left of the plot by default.}

\item{label}{The title of the respective axis (for \code{xlab()} or \code{ylab()}) or
of the plot (for \code{ggtitle()}).}
}
\description{
Good labels are critical for making your plots accessible to a wider
audience. Always ensure the axis and legend labels display the full
variable name. Use the plot \code{title} and \code{subtitle} to explain the
main findings. It's common to use the \code{caption} to provide information
about the data source. \code{tag} can be used for adding identification tags
to differentiate between multiple plots.
}
\details{
You can also set axis and legend labels in the individual scales (using
the first argument, the \code{name}). If you're changing other scale options, this
is recommended.

If a plot already has a title, subtitle, caption, etc., and you want to
remove it, you can do so by setting the respective argument to \code{NULL}. For
example, if plot \code{p} has a subtitle, then \code{p + labs(subtitle = NULL)} will
remove the subtitle from the plot.
}
\examples{
p <- ggplot(mtcars, aes(mpg, wt, colour = cyl)) + geom_point()
p + labs(colour = "Cylinders")
p + labs(x = "New x label")

# The plot title appears at the top-left, with the subtitle
# display in smaller text underneath it
p + labs(title = "New plot title")
p + labs(title = "New plot title", subtitle = "A subtitle")

# The caption appears in the bottom-right, and is often used for
# sources, notes or copyright
p + labs(caption = "(based on data from ...)")

# The plot tag appears at the top-left, and is typically used
# for labelling a subplot with a letter.
p + labs(title = "title", tag = "A")

# If you want to remove a label, set it to NULL.
p + labs(title = "title") + labs(title = NULL)
}
