% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotly_histogram.R
\name{ggplotly_histogram}
\alias{ggplotly_histogram}
\title{Clean 'ggplot2' Histogram to be Converted to 'Plotly'}
\usage{
ggplotly_histogram(data = NULL, mapping = NULL, position = "stack",
  ..., binwidth = NULL, na.rm = FALSE, show.legend = NA)
}
\arguments{
\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that calculates width from unscaled x. Here, "unscaled x"
refers to the original x values in the data, before application of any
scale transformation. When specifying a function along with a grouping
structure, the function will be called once per group.
The default is to use \code{bins}
bins that cover the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}
}
\value{
ggplot bar layer
}
\description{
Create 'ggplot2' histogram that translate nicely to 'plotly'.
}
\details{
`ggplotly_histogram()` is a function that is used to create a 'ggplot2' histogram, yet on conversion to 'plotly' using 'ggplotly()', the resulted plot will hold the correct labeling information, which are "Range", "Count" and "Density".
}
\examples{

library(ggplot2)
library(plotly)
# create the histogram using `ggplotly_histogram()`
p <- ggplot() + ggplotly_histogram(data = ToothGrowth, mapping = aes(len))+
xlab("len")

# convert `ggplot` object to `plotly` object
ggplotly(p, tooltip = c("Range", "count", "density"))
}
