% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-table.R
\name{geom_table}
\alias{geom_table}
\alias{geom_table_npc}
\title{Inset tables}
\usage{
geom_table(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_table_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific data set - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
\code{geom_table} adds a textual table directly to the ggplot using syntax
similar to that of \code{\link[ggplot2]{geom_label}} while
\code{geom_table_npc} is similar to \code{geom_label_npc} in that \code{x}
and \code{y} coordinates are given in npc units.
}
\details{
The "width" and "height" of the table, like for text elements are 0, so
stacking and dodging tables will not work by default. In addition, axis
limits are not automatically expanded to include the whole tables, but
instead only their x and y coordinates. Obviously, tables do have height and
width, but they are in physical units, not data units. The amount of space
they occupy on a plot is not constant in data units: when you resize a plot,
tables stay the same size, but the size of the axes changes.
}
\note{
These geoms work only with tibbles as \code{data}, as they expects a
  list of data frames or tibbles ("tb" objects) to be mapped to the
  \code{label} aesthetic. Aesthetics mappings in the inset plot are
  independent of those in the base plot.

  In the case of \code{geom_table()}, \code{x} and \code{y} aesthetics
  determine the position of the whole inset table, similarly to that of a text
  label, justification is interpreted as indicating the position of the table
  with respect to the $x$ and $y$ coordinates in the data, and \code{angle}
  is used to rotate the table as a whole.

  In the case of \code{geom_table_npc()}, \code{npcx} and \code{npcy} aesthetics
  determine the position of the whole inset table, similarly to that of a text
  label, justification is interpreted as indicating the position of the table
  with respect to the $x$ and $y$ coordinates in "npc" units, and \code{angle}
  is used to rotate the table as a whole.

  \strong{\code{annotate()} cannot be used with \code{geom = "table"}}. Use
  \code{\link[ggplot2]{annotation_custom}} directly when adding inset tables
  as annotations.
}
\section{Alignment}{
 You can modify table alignment with the \code{vjust} and
  \code{hjust} aesthetics. These can either be a number between 0
  (right/bottom) and 1 (top/left) or a character ("left", "middle", "right",
  "bottom", "center", "top").
}

\section{Inset size}{
 You can modify inset table size with the \code{size}
  aesthetics, which determines the size of text within the table.
}

\examples{
library(dplyr)
library(tibble)

mtcars \%>\%
  group_by(cyl) \%>\%
  summarize(wt = mean(wt), mpg = mean(mpg)) \%>\%
  ungroup() \%>\%
  mutate(wt = sprintf("\%.2f", wt),
         mpg = sprintf("\%.1f", mpg)) -> tb

df <- tibble(x = 0.95, y = 0.95, tb = list(tb))

ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table_npc(data = df, aes(npcx = x, npcy = y, label = tb),
                 hjust = 1, vjust = 1)

}
\references{
This geometry is inspired on answers to two questions in
  Stackoverflow. In contrast to these earlier examples, the current geom
  obeys the grammar of graphics, and attempts to be consistent with the
  behaviour of 'ggplot2' geometries.
  \url{https://stackoverflow.com/questions/12318120/adding-table-within-the-plotting-region-of-a-ggplot-in-r}
  \url{https://stackoverflow.com/questions/25554548/adding-sub-tables-on-each-panel-of-a-facet-ggplot-in-r?}
}
\seealso{
function \code{\link[gridExtra]{tableGrob}} as it is used to
  construct the table.

Other Statistics for adding insets to ggplots: 
\code{\link{geom_grob}()},
\code{\link{geom_plot}()}
}
\concept{Statistics for adding insets to ggplots}
