% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-label-npc.r, R/geom-text-npc.r
\name{geom_label_npc}
\alias{geom_label_npc}
\alias{geom_text_npc}
\title{Text with Normalised Parent Coordinates}
\usage{
geom_label_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = grid::unit(0.25, "lines"),
  label.r = grid::unit(0.15, "lines"),
  label.size = 0.25,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_text_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific data set - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{check_overlap}{If `TRUE`, text that overlaps previous text in the same
layer will not be plotted.}
}
\description{
`geom_text_npc()` adds text directly to the plot. `geom_label_npc()` draws a
rectangle behind the text, making it easier to read. The difference is that x
and y mappings are expected to be given in `npc` graphic units. They are
intended to be used for positioning text relative to the physical dimensions
of a plot. This can be achieved with `annotate()` except when faceting is
used.
}
\details{
Note that the "width" and "height" of a text element are 0, so stacking and
dodging text will not work by default, and axis limits are not automatically
expanded to include all text. Obviously, labels do have height and width, but
they are physical units, not data units. The amount of space they occupy on
the plot is not constant in data units: when you resize a plot, labels stay
the same size, but the size of the axes changes.

`geom_text_npc()` and `geom_label_npc()` add labels for each row in the data,
even if coordinates x, y are set to single values in the call to
`geom_label_npc()` or `geom_text_npc()`. To add labels at specified points
use [annotate()] with `annotate(geom = "text_npc", ...)` or `annotate(geom =
"label_npc", ...)`.
}
\note{
This geom is identical to 'ggplot2' \code{geom_text()} except that it
  interprets \code{x} and \code{y} positions in \code{npc} units. It
  translates \code{x} and \code{y} coordinates from npc units to native data
  units and calls functions from 'ggplot2''s GeomText().
}
\section{`geom_label_npc()`}{
 Currently `geom_label_npc()` does not support
  the `angle` aesthetic and is considerably slower than `geom_text_npc()`.
  The `fill` aesthetic controls the background colour of the label.
}

\section{Alignment}{
 You can modify text alignment with the `vjust` and
  `hjust` aesthetics. These can either be a number between 0 (right/bottom)
  and 1 (top/left) or a character (`"left"`, `"middle"`, `"right"`,
  `"bottom"`, `"center"`, `"top"`). There are two special alignments:
  `"inward"` and `"outward"`. Inward always aligns text towards the center,
  and outward aligns it away from the center. When using textual positions
  a shift is added based on grouping, however unused levels are not dropped.
  In plots with faceting so that not all groups appear in each panel, gaps
  will appear in between labels. To solve this pass numeric values for
  the npc coordinates of each label instead of character strings.
}

\examples{

df <- data.frame(
  x = c(0, 0, 1, 1, 0.5),
  x.chr = c("left", "left", "right", "right", "center"),
  y = c(0, 1, 0, 1, 0.5),
  y.chr = c("bottom", "top", "bottom", "top", "middle"),
  text = c("bottom-left", "top-left", "bottom-right", "top-right", "center-middle")
)
ggplot(df) +
  geom_text_npc(aes(npcx = x, npcy = y, label = text))

ggplot(df) +
  geom_text_npc(aes(npcx = x.chr, npcy = y.chr, label = text))

ggplot(data = mtcars, mapping = aes(wt, mpg)) +
  geom_point() +
  geom_text_npc(data = df, aes(npcx = x, npcy = y, label = text))

ggplot(data = mtcars, mapping = aes(wt, mpg)) +
  geom_point() +
  geom_text_npc(data = df, aes(npcx = x, npcy = y, label = text)) +
  expand_limits(y = 40, x = 6)

ggplot(data = mtcars) +
  geom_point(mapping = aes(wt, mpg)) +
  geom_label_npc(data = df, aes(npcx = x, npcy = y, label = text))

}
\seealso{
\code{\link[ggplot2]{geom_text}}
}
