% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-label-npc.r, R/geom-text-npc.r
\name{geom_label_npc}
\alias{geom_label_npc}
\alias{geom_text_npc}
\title{Text with Normalised Parent Coordinates}
\usage{
geom_label_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = grid::unit(0.25, "lines"),
  label.r = grid::unit(0.15, "lines"),
  label.size = 0.25,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_text_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific data set - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{check_overlap}{If `TRUE`, text that overlaps previous text in the same
layer will not be plotted.}
}
\description{
\code{geom_text_npc()} adds text directly to the plot.
\code{geom_label_npc()} draws a rectangle behind the text, making it easier
to read. The difference is that \code{x} and \code{y} mappings are expected
to be given in \code{npc} graphic units, using pseudo-aesthetics. Their
intended use is to add annotations to a plot.
}
\details{
This geom is identical to 'ggplot2' \code{\link[ggplot2]{geom_text}}
  except that it interprets \code{npcx} and \code{npcy} positions in
  \code{npc} units. It translates \code{npcx} and \code{npcy} coordinates
  using a pseudo-aesthetic with a fixed scale. The generation of grobs is
  done with calls to functions imported from package 'ggplot2'.
}
\section{Alignment}{
 With textual positions and groups a shift is added to
  successive labels to avoid overlaps. The shift is based on grouping,
  however unused levels are not dropped. In plots with faceting, if not
  all groups appear in each panel, there will be blank spaces in between
  labels. To solve this pass numeric values for the npc coordinates of each
  label instead of character strings.

 You can modify text alignment with the \code{vjust} and
  \code{hjust} aesthetics. These can either be a number between 0
  (right/bottom) and 1 (top/left) or a character (\code{"left"},
  \code{"middle"}, \code{"right"}, \code{"bottom"}, \code{"center"},
  \code{"top"}). In addition, you can use special alignments for
  justification including \code{"position"}, \code{"inward"} and
  \code{"outward"}. Inward always aligns text towards the center of the
  plotting area, and outward aligns it away from the center of the plotting
  area. If tagged with \code{_mean} or \code{_median} (e.g.,
  \code{"outward_mean"}) the mean or median of the data in the panel along
  the corresponding axis is used as center. If the characters following the
  underscore represent a number (e.g., \code{"outward_10.5"}) the reference
  point will be this value in data units. Position justification is computed
  based on the direction of the displacement of the position of the label so
  that each individual text or label is justified outwards from its original
  position. The default justification is \code{"position"}.

  If no position displacement is applied, or a position function defined in
  'ggplot2' is used, these geometries behave similarly to the corresponding
  ones from package 'ggplot2' with a default justification of \code{0.5} and
  no segment drawn.
}

\section{Plot boundaries and clipping}{
 Note that when you change the scale
  limits for \emph{x} and/or \emph{y} of a plot, text labels stay the same
  size, as determined by the \code{size} aesthetic, given in millimetres. The
  actual size as seen in the plotted output is decided during the rendering
  of the plot to a graphics device. Limits are expanded only to include the
  anchor point of the labels because the "width" and "height" of a text
  element are 0 (as seen by ggplot2). Text labels do have height and width,
  but in grid units, not data units.
}

\examples{

df <- data.frame(
  x = c(0, 0, 1, 1, 0.5),
  x.chr = c("left", "left", "right", "right", "center"),
  y = c(0, 1, 0, 1, 0.5),
  y.chr = c("bottom", "top", "bottom", "top", "middle"),
  text = c("bottom-left", "top-left", "bottom-right", "top-right", "center-middle")
)

ggplot(df) +
  geom_text_npc(aes(npcx = x, npcy = y, label = text))

ggplot(df) +
  geom_text_npc(aes(npcx = x.chr, npcy = y.chr, label = text))

ggplot(data = mtcars, mapping = aes(wt, mpg)) +
  geom_point() +
  geom_text_npc(data = df, aes(npcx = x, npcy = y, label = text))

ggplot(data = mtcars, mapping = aes(wt, mpg)) +
  geom_point() +
  geom_text_npc(data = df, aes(npcx = x, npcy = y, label = text)) +
  expand_limits(y = 40, x = 6)

ggplot(data = mtcars) +
  geom_point(mapping = aes(wt, mpg)) +
  geom_label_npc(data = df, aes(npcx = x, npcy = y, label = text))

}
\seealso{
\code{\link[ggplot2]{geom_text}}
}
