% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_palette.R
\name{set_palette}
\alias{set_palette}
\alias{set_palette}
\alias{change_palette}
\title{Set Color Palette}
\usage{
set_palette(p, palette)

change_palette(p, palette)
}
\arguments{
\item{p}{a ggplot}

\item{palette}{Color palette. Allowed values include: \itemize{ \item
\strong{Grey color palettes}: "grey" or "gray"; \item \strong{RColorBrewer
palettes}, see \code{\link[RColorBrewer]{brewer.pal}} and details section.
Examples of palette names include: "RdBu", "Blues", "Dark2", "Set2", ...;
\item \strong{Custom color palettes}. For example, palette = c("#00AFBB",
"#E7B800", "#FC4E07"); \item \strong{ggsci scientific journal palettes},
e.g.: "npg", "aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and
"rickandmorty". }}
}
\description{
Change color palette. \code{change_palette()} is an alias of \code{set_palette()}.
}
\examples{
# Load data
data("ToothGrowth")
df <- ToothGrowth

# Basic plot
p <- ggboxplot(df, x = "dose", y = "len",
   color = "dose")
p

# Change the color palette
set_palette(p, "jco")
}
\seealso{
\link{get_palette}.
}
