% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font.R
\name{font}
\alias{font}
\title{Change the Appearance of Titles and Axis Labels}
\usage{
font(object, size = NULL, color = NULL, face = NULL, family = NULL,
  ...)
}
\arguments{
\item{object}{character string specifying the plot components. Allowed values
include: \itemize{ \item \code{"title"} for the main title \item
\code{"subtitle"} for the plot subtitle \item \code{"caption"} for the plot
caption \item \code{"legend.title"} for the legend title \item
\code{"legend.text"} for the legend text \item \code{"x", "xlab", or "x.title"}
for x axis label \item \code{"y", "ylab", or "y.title"} for y axis label \item
\code{"xy", "xylab", "xy.title" or "axis.title"} for both x and y axis
labels \item \code{"x.text"} for x axis texts (x axis tick labels) \item
\code{"y.text"} for y axis texts (y axis tick labels) \item \code{"xy.text"}
or \code{"axis.text"} for both x and y axis texts }}

\item{size}{numeric value specifying the font size, (e.g.: \code{size = 12}).}

\item{color}{character string specifying the font color, (e.g.: \code{color =
"red"}).}

\item{face}{the font face or style. Allowed values include one of
\code{"plain", "bold", "italic", "bold.italic"}, (e.g.: \code{face =
"bold.italic"}).}

\item{family}{the font family.}

\item{...}{other arguments to pass to the function
\code{\link[ggplot2]{element_text}()}.}
}
\description{
Change the appearance of the main title, subtitle, caption, axis
 labels and text, as well as the legend title and texts. Wrapper around
 \code{\link[ggplot2]{element_text}()}.
}
\examples{
# Load data
data("ToothGrowth")

# Basic plot
p <- ggboxplot(ToothGrowth, x = "dose", y = "len", color = "dose",
              title = "Box Plot created with ggpubr",
              subtitle = "Length by dose",
              caption = "Source: ggpubr",
              xlab ="Dose (mg)", ylab = "Teeth length")
p

# Change the appearance of titles and labels
p +
 font("title", size = 14, color = "red", face = "bold.italic")+
 font("subtitle", size = 10, color = "orange")+
 font("caption", size = 10, color = "orange")+
 font("xlab", size = 12, color = "blue")+
 font("ylab", size = 12, color = "#993333")+
 font("xy.text", size = 12, color = "gray", face = "bold")

# Change the appearance of legend title and texts
p +
 font("legend.title", color = "blue", face = "bold")+
 font("legend.text", color = "red")

}
