% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal_aes.R
\name{reveal_aes}
\alias{reveal_aes}
\title{Reveal plot by aes}
\usage{
reveal_aes(p, aes = "group", order = NULL, max = 20)
}
\arguments{
\item{p}{A ggplot2 object}

\item{aes}{which aesthetic to reveal E.g.: group, colour, shape, linetype}

\item{order}{(optional) A numeric vector specifying in which order to reveal
levels of the specified aesthetic.

For example, if \code{aes='shape'} and the plot uses three shapes, \code{order = c(3, 2, 1)} will invert the order in which they are revealed.

Any shape not included in the vector will be omitted from the incremental
plots. E.g.: with \code{order = c(3, 1)}, the second shape is not shown.

By default, the first plot is blank, showing layout elements (title,
legends, axes, etc) but no data. To omit the blank plot, include \code{-1}: e.g.
\code{order = c(-1, 3, 1)}, or \code{order = -1}.}

\item{max}{maximum number of unique levels of aesthetic to be used}
}
\value{
A list of ggplot2 objects, which can be passed to \code{\link[=reveal_save]{reveal_save()}}
}
\description{
Turns a ggplot into a list of plots, showing data incrementally by an
arbitrary aesthetic.
}
\examples{
# Create full plot
library(ggplot2)

 p <- mtcars |>
   ggplot(aes(mpg, wt,
              color = factor(vs),
              group = factor(vs))) +
   geom_point(aes(shape=factor(am)), size=2) +
   geom_smooth(method="lm",
               formula = 'y ~ x',
               linewidth=1) 
 p

 plot_list <- reveal_aes(p, "shape")
 plot_list[[1]]
 plot_list[[2]]
 plot_list[[3]]
 plot_list[[4]]


# Save plots
reveal_save(plot_list, "myplot.png", width = 8, height = 4, path = tempdir())

# Clean temp files
file.remove(list.files(path = tempdir(), pattern = "myplot", full.names = TRUE)) 
}
