% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-spatial-stars.R
\docType{data}
\name{layer_spatial.stars}
\alias{layer_spatial.stars}
\alias{annotation_spatial.stars}
\alias{StatSpatialStars}
\alias{StatSpatialStarsAnnotation}
\alias{StatSpatialStarsDf}
\alias{GeomSpatialStars}
\title{Spatial ggplot2 layer for stars objects}
\format{
An object of class \code{StatSpatialStars} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatSpatialStars} (inherits from \code{StatSpatialStars}, \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatSpatialStarsDf} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 5.

An object of class \code{GeomSpatialStars} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
\method{layer_spatial}{stars}(
  data,
  mapping = NULL,
  interpolate = NULL,
  is_annotation = FALSE,
  lazy = FALSE,
  dpi = 150,
  options = character(0),
  ...
)

\method{annotation_spatial}{stars}(data, mapping = NULL, interpolate = NULL, ...)

StatSpatialStars

StatSpatialStarsAnnotation

StatSpatialStarsDf

GeomSpatialStars
}
\arguments{
\item{data}{A stars object}

\item{mapping}{Currently, only RGB or RGBA rasters are supported. In the future, one may be able to
map specific bands to the fill and alpha aesthetics.}

\item{interpolate}{Interpolate resampling for rendered raster image}

\item{is_annotation}{Lets raster exist without modifying scales}

\item{lazy}{Delay projection and resample of raster until the plot is being rendered}

\item{dpi}{if lazy = TRUE, the dpi to which the raster should be resampled}

\item{options}{GDAL options for warping/resampling (see \link[stars:st_warp]{st_warp})}

\item{...}{Passed to other methods}
}
\value{
A ggplot2 layer
}
\description{
This is intended for use with RGB(A) rasters (e.g., georeferenced imagery or photos). To work with
bands as if they were columns, use \link{df_spatial} and \link{geom_raster}.
}
\keyword{datasets}
