% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-calibration-spct.R
\name{scale_y_multipliers_continuous}
\alias{scale_y_multipliers_continuous}
\title{Calibration multipliers y-scale}
\usage{
scale_y_multipliers_continuous(
  unit.exponent = 0,
  name = multipliers_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1), axis.symbols =
    axis.symbols),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["e.mult"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw the calibration
multipliers used to convert pixel response rate (counts per second) into
energy irradiance units.
}
\note{
This function only alters two default arguments, please, see
  documentation for \code{\link[ggplot2]{scale_continuous}}
}
