% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{Rfr_label}
\alias{Rfr_label}
\alias{Rfr_specular_label}
\title{Reflectance axis labels}
\usage{
Rfr_label(
  unit.exponent = ifelse(pc.out, -2, 0),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  pc.out = getOption("ggspectra.pc.out", default = FALSE),
  Rfr.type
)

Rfr_specular_label(
  unit.exponent = ifelse(pc.out, -2, 0),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  pc.out = getOption("ggspectra.pc.out", default = FALSE)
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{pc.out}{logical, if TRUE use percent as default instead of fraction
of one.}

\item{Rfr.type}{character, either "total" or "specular".}
}
\value{
a character string or an R expression.
}
\description{
Generate spectral reflectance labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\note{
Default for \code{label.text} depends on the value passed as argument
  to \code{Rfr.type}.
}
\examples{

Rfr_label(Rfr.type = "specular")
Rfr_label(Rfr.type = "total")


Rfr_specular_label()
Rfr_specular_label(axis.symbols = FALSE)
Rfr_specular_label(-2)
Rfr_specular_label(-3)
Rfr_specular_label(format = "R.expression")
Rfr_specular_label(format = "LaTeX")
Rfr_specular_label(-3, format = "LaTeX")

}
