% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodgev.R, R/position-dodge2v.R,
%   R/position-jitterdodgev.R, R/position-stackv.R, R/position.R
\name{position_dodgev}
\alias{position_dodgev}
\alias{position_dodge2v}
\alias{position_jitterdodgev}
\alias{position_stackv}
\alias{position_fillv}
\alias{position-vertical}
\title{Vertical Positions}
\usage{
position_dodgev(height = NULL, preserve = c("total", "single"))

position_dodge2v(height = NULL, preserve = c("single", "total"),
  padding = 0.1, reverse = FALSE)

position_jitterdodgev(jitter.height = NULL, jitter.width = 0,
  dodge.height = 0.75, seed = NA)

position_stackv(hjust = 1, reverse = FALSE)

position_fillv()
}
\arguments{
\item{height}{Dodging height, when different to the height of the individual
elements. This is useful when you want to align narrow geoms with taller
geoms.}

\item{preserve}{Should dodging preserve the total width of all elements
at a position, or the width of a single element?}

\item{padding}{Padding between elements at the same position. Elements are
shrunk by this proportion to allow space between them. Defaults to 0.1.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}

\item{jitter.height}{degree of jitter in y direction. Defaults to 0.}

\item{jitter.width}{degree of jitter in x direction. Defaults to 40\% of the
resolution of the data.}

\item{dodge.height}{the amount to dodge in the y direction. Defaults to 0.75,
the default \code{position_dodgev()} height.}

\item{seed}{A random seed to make the jitter reproducible.
Useful if you need to apply the same jitter twice, e.g., for a point and
a corresponding label.
The random seed is reset after jittering.
If \code{NA} (the default value), the seed is initialised with a random value;
this makes sure that two subsequent calls start with a different seed.
Use \code{NULL} to use the current random seed and also avoid resetting
(the behaviour of \pkg{ggplot} 2.2.1 and earlier).}

\item{hjust}{Horizontal adjustment for geoms that have a position
(like points or lines), not a dimension (like bars or areas). Set to
`0` to align with the left side, `0.5` for the middle,
and `1` (the default) for the right side.}
}
\description{
Vertical versions of \code{\link[ggplot2]{position_dodge}()},
\code{\link[ggplot2]{position_jitterdodge}()},
\code{\link[ggplot2]{position_fill}()},
\code{\link[ggplot2]{position_stack}()},
}
