% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbetweenstats.R
\name{ggbetweenstats}
\alias{ggbetweenstats}
\title{violin plots for group or condition comparisons}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{xlab}{Label for \code{x} axis variable.}

\item{ylab}{Label for \code{y} axis variable.}

\item{type}{Type of statistic expected ("parametric" or "nonparametric" or
"robust").Corresponding abbreviations are also accepted: "p" (for
parametric), "np" (nonparametric), "r" (robust), resp.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests
("biased" (Cohen's d, partial eta-squared) or "unbiased" (Hedge's g,
omega-squared)).}

\item{title}{The text for the plot title.}

\item{caption}{The text for the plot caption.}

\item{k}{Number of decimal places expected for results.}

\item{var.equal}{A logical variable indicating whether to treat the two
variances as being equal (Default: \code{FALSE}).}

\item{nboot}{Number of bootstrap samples.}

\item{outlier.color}{Default aesthetics for outliers.}

\item{outlier.tagging}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}

\item{outlier.label}{Label to put on the outliers that have been tagged.}

\item{mean.plotting}{Decides whether mean is to be highlighted and its value
to be displayed (Default: \code{TRUE}).}

\item{mean.color}{Color for the data point corresponding to mean.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Violin plots for between-subjects designs with statistical
details included in the plot as a subtitle.
}
\examples{

library(datasets)

# simple function call with the defaults
ggstatsplot::ggbetweenstats(
data = datasets::iris,
x = Species,
y = Sepal.Length
)

# more detailed function call
ggstatsplot::ggbetweenstats(
data = datasets::ToothGrowth,
x = supp,
y = len,
xlab = "Supplement type",
ylab = "Tooth length",
outlier.tagging = TRUE)

}
\author{
Indrajeet Patil
}
