% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_two_sample_ttest}
\alias{bf_two_sample_ttest}
\title{Bayesian two-samples \emph{t}-test.}
\usage{
bf_two_sample_ttest(data, x, y, paired = FALSE, bf.prior = 0.707,
  caption = NULL, output = "null", k = 2, ...)
}
\arguments{
\item{data}{for use with \code{formula}, a data frame containing all the
data}

\item{x}{a vector of observations for the first (or only) group}

\item{y}{a vector of observations for the second group (or condition, for
paired)}

\item{paired}{if \code{TRUE}, observations are paired}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"}, which will
contain text for evidence in favor of the null hypothesis or H0)  or
\code{"alternative"} (or \code{"title"} or \code{"H1"}) or \code{"results"}, which will return
a dataframe with results all the details).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Bayesian two-samples \emph{t}-test.
}
\examples{

# for reproducibility
set.seed(123)

# to get caption (default)
bf_two_sample_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  bf.prior = 0.880
)

# to see results
bf_two_sample_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  output = "results"
)

# for paired sample test
bf_two_sample_ttest(
  data = dplyr::filter(
    ggstatsplot::intent_morality,
    condition \%in\% c("accidental", "attempted"),
    harm == "Poisoning"
  ),
  x = condition,
  y = rating,
  paired = TRUE,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_oneway_anova}}
}
\author{
Indrajeet Patil
}
