% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats.R
\name{mean_ggrepel}
\alias{mean_ggrepel}
\title{Adding labels for mean values.}
\usage{
mean_ggrepel(plot, mean.data, mean.size = 5, mean.color = "darkred",
  mean.label.size = 3, mean.label.fontface = "bold",
  mean.label.color = "black", inherit.aes = TRUE, ...)
}
\arguments{
\item{plot}{A \code{ggplot} object for which means are to be displayed.}

\item{mean.data}{A dataframe containing means for each level of the factor.
The columns should be titled \code{x}, \code{y}, and \code{label}.}

\item{mean.size}{Point size for the data point corresponding to mean
(Default: \code{5}).}

\item{mean.color}{Color for the data point corresponding to mean (Default:
\code{"darkred"}).}

\item{mean.label.size}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{mean.label.fontface}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{mean.label.color}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{Additional arguments.}
}
\description{
Adding labels for mean values.
}
\examples{

\dontrun{
# this internal function may not have much utility outside of the package
set.seed(123)
library(ggplot2)

# make a plot
p <- ggplot(data = iris, aes(x = Species, y = Sepal.Length)) +
  geom_boxplot()

# get a dataframe with means
mean_dat <- ggstatsplot:::mean_labeller(
  data = iris,
  x = Species,
  y = Sepal.Length,
  mean.ci = TRUE,
  k = 3
) \%>\%
  dplyr::rename(.data = ., x = Species, y = Sepal.Length)

# add means
ggstatsplot:::mean_ggrepel(
  plot = p,
  mean.data = mean_dat,
  mean.color = "darkgreen"
)
}
}
\author{
Indrajeet Patil
}
\keyword{internal}
