% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_gghistostats_subtitles.R
\name{subtitle_onesample}
\alias{subtitle_onesample}
\title{Making text subtitle for one sample t-test and its nonparametric and
robust equivalents.}
\usage{
subtitle_onesample(data = NULL, x, type = "parametric",
  test.value = 0, bf.prior = 0.707, robust.estimator = "onestep",
  nboot = 100, k = 3, messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken. This argument is optional.}

\item{x}{A numeric variable.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}). Abbreviations accepted are \code{"p"} or \code{"np"} or
\code{"r"} or \code{"bf"}, respectively.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{robust.estimator}{If \code{test = "robust"} robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{nboot}{Number of bootstrap samples for robust one-sample location test
(Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer) (Default: \code{k = 3}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Making text subtitle for one sample t-test and its nonparametric and
robust equivalents.
}
\examples{

# for reproducibility
set.seed(123)

subtitle_onesample(
  x = iris$Sepal.Length,
  type = "r"
)
}
\seealso{
\code{\link{gghistostats}}
}
\author{
Indrajeet Patil
}
