% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_two_sample_ttest}
\alias{bf_two_sample_ttest}
\title{Bayesian two-samples \emph{t}-test.}
\usage{
bf_two_sample_ttest(data, x, y, paired = FALSE, bf.prior = 0.707,
  caption = NULL, output = "caption", k = 2)
}
\arguments{
\item{data}{A dataframe from which variables specified are preferentially to
be taken.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{if \code{TRUE}, observations are paired}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"caption"} (which will contain text for evidence
in favor of null)  or \code{"results"} (which will return the dataframe with
results).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}
}
\description{
Bayesian two-samples \emph{t}-test.
}
\examples{

# for reproducibility
set.seed(123)

# to get caption (default)
bf_two_sample_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  bf.prior = 0.880
)

# to see results
bf_two_sample_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  output = "results"
)

# for paired sample test
bf_two_sample_ttest(
  data = dplyr::filter(
    ggstatsplot::intent_morality,
    condition \%in\% c("accidental", "attempted"),
    harm == "Poisoning"
  ),
  x = condition,
  y = rating,
  paired = TRUE,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_oneway_anova}}
}
\author{
Indrajeet Patil
}
