% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpiestats.R
\name{ggpiestats}
\alias{ggpiestats}
\title{Pie charts with statistical tests}
\usage{
ggpiestats(
  data,
  x,
  y = NULL,
  counts = NULL,
  type = "parametric",
  paired = FALSE,
  results.subtitle = TRUE,
  label = "percentage",
  label.args = list(direction = "both"),
  label.repel = FALSE,
  digits = 2L,
  proportion.test = results.subtitle,
  digits.perc = 0L,
  bf.message = TRUE,
  ratio = NULL,
  conf.level = 0.95,
  sampling.plan = "indepMulti",
  fixed.margin = "rows",
  prior.concentration = 1,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  legend.title = NULL,
  ggtheme = ggstatsplot::theme_ggstatsplot(),
  package = "RColorBrewer",
  palette = "Dark2",
  ggplot.component = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{The variable to use as the \strong{rows} in the contingency table. Please
note that if there are empty factor levels in your variable, they will be
dropped.}

\item{y}{The variable to use as the \strong{columns} in the contingency table.
Please note that if there are empty factor levels in your variable, they
will be dropped. Default is \code{NULL}. If \code{NULL}, one-sample proportion test
(a goodness of fit test) will be run for the \code{x} variable. Otherwise an
appropriate association test will be run. This argument can not be \code{NULL}
for \code{\link[=ggbarstats]{ggbarstats()}}.}

\item{counts}{The variable in data containing counts, or \code{NULL} if each row
represents a single observation.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{paired}{Logical indicating whether data came from a within-subjects or
repeated measures design study (Default: \code{FALSE}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{label}{Character decides what information needs to be displayed
on the label in each pie slice. Possible options are \code{"percentage"}
(default), \code{"counts"}, \code{"both"}.}

\item{label.args}{Additional aesthetic arguments that will be passed to
\code{\link[ggplot2:geom_text]{ggplot2::geom_label()}}.}

\item{label.repel}{Whether labels should be repelled using \code{{ggrepel}}
package. This can be helpful in case of overlapping labels.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{proportion.test}{Decides whether proportion test for \code{x} variable is to
be carried out for each level of \code{y}. Defaults to \code{results.subtitle}. In
\code{\link[=ggbarstats]{ggbarstats()}}, only \emph{p}-values from this test will be displayed.}

\item{digits.perc}{Numeric that decides number of decimal places for
percentage labels (Default: \code{0L}).}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{ratio}{A vector of proportions: the expected proportions for the
proportion test (should sum to \code{1}). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
E.g., \code{ratio = c(0.5, 0.5)} for two levels,
\code{ratio = c(0.25, 0.25, 0.25, 0.25)} for four levels, etc.}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{sampling.plan}{Character describing the sampling plan. Possible options:
\itemize{
\item \code{"indepMulti"} (independent multinomial; default)
\item \code{"poisson"}
\item \code{"jointMulti"} (joint multinomial)
\item \code{"hypergeom"} (hypergeometric).
For more, see \code{\link[BayesFactor:contingencyTableBF]{BayesFactor::contingencyTableBF()}}.
}}

\item{fixed.margin}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}

\item{prior.concentration}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}

\item{legend.title}{Title text for the legend.}

\item{ggtheme}{A \code{{ggplot2}} theme. Default value is
\code{\link[=theme_ggstatsplot]{theme_ggstatsplot()}}. Any of the \code{{ggplot2}} themes (e.g.,
\code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}}), or themes from extension packages are allowed
(e.g., \code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()},
etc.). But note that sometimes these themes will remove some of the details
that \code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{\link[=ggbetweenstats]{ggbetweenstats()}} shows details about multiple comparison test as a
label on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}

\item{package, palette}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}

\item{...}{Currently ignored.}
}
\description{
Pie charts for categorical data with statistical details included in the plot
as a subtitle.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggpiestats.html}
}
\section{Summary of graphics}{
\tabular{lll}{
   graphical element \tab \code{geom} used \tab argument for further modification \cr
   pie slices \tab \code{ggplot2::geom_col()} \tab \code{NA} \cr
   labels \tab \code{ggplot2::geom_label()}/\code{ggrepel::geom_label_repel()} \tab \code{label.args} \cr
}
}

\section{Contingency table analyses}{



The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}
\subsection{two-way table}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab Design \tab Test \tab Function used \cr
   Parametric/Non-parametric \tab Unpaired \tab Pearson's chi-squared test \tab \code{stats::chisq.test()} \cr
   Bayesian \tab Unpaired \tab Bayesian Pearson's chi-squared test \tab \code{BayesFactor::contingencyTableBF()} \cr
   Parametric/Non-parametric \tab Paired \tab McNemar's chi-squared test \tab \code{stats::mcnemar.test()} \cr
   Bayesian \tab Paired \tab No \tab No \cr
}


\strong{Effect size estimation}\tabular{lllll}{
   Type \tab Design \tab Effect size \tab CI available? \tab Function used \cr
   Parametric/Non-parametric \tab Unpaired \tab Cramer's \emph{V} \tab Yes \tab \code{effectsize::cramers_v()} \cr
   Bayesian \tab Unpaired \tab Cramer's \emph{V} \tab Yes \tab \code{effectsize::cramers_v()} \cr
   Parametric/Non-parametric \tab Paired \tab Cohen's \emph{g} \tab Yes \tab \code{effectsize::cohens_g()} \cr
   Bayesian \tab Paired \tab No \tab No \tab No \cr
}

}

\subsection{one-way table}{

\strong{Hypothesis testing}\tabular{lll}{
   Type \tab Test \tab Function used \cr
   Parametric/Non-parametric \tab Goodness of fit chi-squared test \tab \code{stats::chisq.test()} \cr
   Bayesian \tab Bayesian Goodness of fit chi-squared test \tab (custom) \cr
}


\strong{Effect size estimation}\tabular{llll}{
   Type \tab Effect size \tab CI available? \tab Function used \cr
   Parametric/Non-parametric \tab Pearson's \emph{C} \tab Yes \tab \code{effectsize::pearsons_c()} \cr
   Bayesian \tab No \tab No \tab No \cr
}

}

}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# for reproducibility
set.seed(123)

# one sample goodness of fit proportion test
p <- ggpiestats(mtcars, vs)

# looking at the plot
p

# extracting details from statistical tests
extract_stats(p)

# association test (or contingency table analysis)
ggpiestats(mtcars, vs, cyl)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{grouped_ggpiestats}}, \code{\link{ggbarstats}},
\code{\link{grouped_ggbarstats}}
}
