% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-smooth-tern.R, R/stat-smooth-tern.R
\docType{data}
\name{geom_smooth_tern}
\alias{GeomSmoothTern}
\alias{StatSmoothTern}
\alias{geom_smooth}
\alias{geom_smooth_tern}
\alias{stat_smooth_tern}
\title{Add a Smoothed Conditional Mean.}
\usage{
geom_smooth_tern(mapping = NULL, data = NULL, method = "auto",
  formula = y ~ x, se = TRUE, position = "identity", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, expand = c(0.5, 0.5), ...)

stat_smooth_tern(mapping = NULL, data = NULL, position = "identity",
  method = "auto", formula = y ~ x, se = TRUE, n = 80, span = 0.75,
  fullrange = FALSE, level = 0.95, method.args = list(), na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, expand = c(0.5, 0.5), ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{method}{smoothing method (function) to use, eg. lm, glm, gam, loess,
rlm. For datasets with n < 1000 default is \code{\link{loess}}. For datasets
with 1000 or more observations defaults to gam, see \code{\link[mgcv]{gam}}
for more details.}

\item{formula}{formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}}

\item{se}{display confidence interval around smooth? (TRUE by default, see
level to control}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{expand}{expand the range of values by this much (vector of length 2) when fullrange is set to TRUE}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{n}{number of points to evaluate smoother at}

\item{span}{Controls the amount of smoothing for the default loess smoother.
Smaller numbers produce wigglier lines, larger numbers produce smoother
lines.}

\item{fullrange}{should the fit span the full range of the plot, or just
the data}

\item{level}{level of confidence interval to use (0.95 by default)}

\item{method.args}{List of additional arguments passed on to the modelling
function defined by \code{method}.}
}
\description{
Aids the eye in seeing patterns in the presence of overplotting.
\code{geom_smooth_tern} and \code{stat_smooth_tern} are effectively aliases: they
both use the same arguments. Use \code{geom_smooth_tern} unless you want to
display the results with a non-standard geom.
}
\examples{
data(Feldspar)
ggtern(data=Feldspar,aes(Ab,An,Or,group=Feldspar)) +  
  geom_smooth_tern(method=lm,fullrange=TRUE,colour='red') + 
  geom_point() +
  labs(title="Example Smoothing")
}
\keyword{datasets}

