% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{prop}
\alias{prop}
\alias{is.prop}
\alias{is.prop_constant}
\alias{is.prop_variable}
\alias{is.prop_reactive}
\title{Create a property.}
\usage{
prop(property, x, scale = NULL, offset = NULL, mult = NULL,
  env = parent.frame(), event = NULL, label = NULL)

is.prop(x)

is.prop_constant(x)

is.prop_variable(x)

is.prop_reactive(x)
}
\arguments{
\item{property}{A property, like "x", "x2", "y", "fill", and so on.}

\item{x}{The value of the property. This can be an atomic vector
(a constant), a name or quoted call (a variable), a single-sided
formula (a constant or variable depending on its contents), or a delayed
reactive (which can be either variable or constant).}

\item{scale}{If \code{NULL}, automatically determine behavior by the kind of
value (constant, variable, or reactive).
If \code{TRUE} use the default scale associated with property.
If \code{FALSE}, do not scale the value.
Otherwise supply a string to select a custom scale.
If \code{x} is an interactive input, then this defaults to the scale
parameter of the input.}

\item{offset, mult}{Additive and multiplicate pixel offset used to adjust
scaled values. These are useful if you want to place labels offset from
points.}

\item{env}{If \code{x} is a quoted call this provides the environment in
which to look for variables not in the data. You should not need this in
ordinary operation.}

\item{event}{An event to which this property applies. One of "update",
"enter", "exit", "hover", "brush".}

\item{label}{A label for this prop to use for reporting errors.}
}
\description{
Properties are used to describe the visual properties of \link{marks}.
You create a single property defintion with \code{prop}, and manage
sets of named properties with \code{\link{props}} (which also provides
shortcuts for creating the most common kind of properties)
}
\examples{
prop("x", 1)
prop("x", ~1)
prop("fill", quote(cyl))
prop("fill", ~cyl)
prop("x", input_slider(0, 100))

# If you have a variable name as a string
var <- "cyl"
prop("x", as.name(var))

# Use a custom scale
prop("y", quote(cyl), scale = "y-2")

# Don't scale variable (i.e. it already makes sense in the visual space)
prop("fill", ~colour, scale = FALSE)

# Use a constant, but scaled
prop("x", 5, scale = TRUE)

# Use other events
prop("y", quote(cyl), scale = "y-2")

}
\seealso{
\code{\link{props}} to manage multiple properties and to
  succintly create the most common types.
}
