% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{lr.test}
\alias{lr.test}
\title{Perform likelihood ratio test between two ghype models.}
\usage{
lr.test(
  nullmodel,
  altmodel,
  df = NULL,
  Beta = TRUE,
  seed = NULL,
  nempirical = NULL,
  parallel = FALSE,
  returnBeta = FALSE,
  method = NULL
)
}
\arguments{
\item{nullmodel}{ghype object. The null model}

\item{altmodel}{ghype object. The alternative model}

\item{df}{optional scalar. the number of degrees of freedom.}

\item{Beta}{boolean, whether to use empirical Beta distribution approximation. Default TRUE}

\item{seed}{scalar, seed for the empirical distribution.}

\item{nempirical}{optional scalar, number of replicates for empirical beta distribution.}

\item{parallel}{optional, number of cores to use or boolean for parallel computation.
If passed TRUE uses all cores-1, else uses the number of cores passed. If none passed
performed not in parallel.}

\item{returnBeta}{boolean, return estimated parameters of Beta distribution? Default FALSE.}

\item{method}{string, for internal use}
}
\value{
p-value of test. If returnBeta=TRUE returns the p-value together with the parameters
 of the beta distribution.
}
\description{
lr.test allows to test between two nested ghype models whether there is
enough evidence for the alternative (more complex) model compared to the null model.
}
\examples{
data("adj_karate")
regularmodel <- regularm(graph = adj_karate, directed = FALSE, selfloops = FALSE)
confmodel <- scm(graph = adj_karate, directed = FALSE, selfloops = FALSE)
lr.test(nullmodel = regularmodel, altmodel = confmodel, seed = 123)

}
