% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibble-sf.R, R/gibble-sp.R, R/gibble.R
\name{gibble}
\alias{gibble}
\alias{gibble.POINT}
\alias{gibble.MULTIPOINT}
\alias{gibble.LINESTRING}
\alias{gibble.MULTILINESTRING}
\alias{gibble.POLYGON}
\alias{gibble.MULTIPOLYGON}
\alias{gibble.list}
\alias{gibble.sfc}
\alias{gibble.sf}
\alias{gibble.trip}
\alias{gibble.Polygon}
\alias{gibble.Polygons}
\alias{gibble.SpatialPolygons}
\alias{gibble.Line}
\alias{gibble.Lines}
\alias{gibble.SpatialLines}
\alias{gibble.SpatialMultiPoints}
\alias{gibble.SpatialPoints}
\alias{gibble.Spatial}
\alias{gibble.default}
\alias{gibble.PATH}
\title{Path-based geometry decomposition}
\usage{
\method{gibble}{POINT}(x, ...)

\method{gibble}{MULTIPOINT}(x, ...)

\method{gibble}{LINESTRING}(x, ...)

\method{gibble}{MULTILINESTRING}(x, ...)

\method{gibble}{POLYGON}(x, ...)

\method{gibble}{MULTIPOLYGON}(x, ...)

\method{gibble}{list}(x, ...)

\method{gibble}{sfc}(x, ...)

\method{gibble}{sf}(x, ...)

\method{gibble}{trip}(x, ...)

\method{gibble}{Polygon}(x, ...)

\method{gibble}{Polygons}(x, ...)

\method{gibble}{SpatialPolygons}(x, ...)

\method{gibble}{Line}(x, ...)

\method{gibble}{Lines}(x, ...)

\method{gibble}{SpatialLines}(x, ...)

\method{gibble}{SpatialMultiPoints}(x, ...)

\method{gibble}{SpatialPoints}(x, ...)

\method{gibble}{Spatial}(x, ...)

gibble(x, ...)

\method{gibble}{default}(x, ...)

\method{gibble}{PATH}(x, ...)
}
\arguments{
\item{x}{geometry model}

\item{...}{arguments reserved for methods, none currently}
}
\value{
data frame summarizing the geometry map, see \code{Details}
}
\description{
A gibble is a geometry map, a summary of the structure of each path within a
simple planar shape. The generic function \code{gibble()} will summarize all paths
within a complex type with a data frame row for each. Each row of the gibble
summary represents a component element of the object's geometry and records
the number of rows (i.e. how many coordinates) and the number of columns (i.e.
the number of axes in the geometric space). Another column \code{type} records the
class of the object, and \code{object} records an identifier for the entire object.
A special case column \code{subobject} identifies the component POLYGON part within
a MULTIPOLYGON. I.e. \code{subobject} is 1 unless that part is a hole. All
identifiers are sequential within the higher level groupings.
}
\details{
Methods are provided for the \code{sf} classes. There is an internal version that
is designed to work fast on sets of structures, by delaying conversion to list
or data frame for as late as possible.

A geometry map is not so helpful on its own, and so does not have a formal
class. It is designed for use within other workflows such as updating the
coordinates of model object  or translating between superficially different
formats.

Gibble is a distillation of the \code{sc_path} encoding of package
\href{https://github.com/hypertidy/silicate}{silicate}, which came from the
\code{map_table} decompositions of spbabel, as an improvement on the single-table
\code{fortify} model used in \code{ggplot2}.
}
\examples{
gibble(minimal_mesh)
}
