% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-qc.R
\name{qc_variance_hist}
\alias{qc_variance_hist}
\title{Create a histogram for the variance within replicates for each pgRNA}
\usage{
qc_variance_hist(
  gimap_dataset,
  filter_replicates_target_col = NULL,
  wide_ar = 0.75
)
}
\arguments{
\item{gimap_dataset}{The special gimap_dataset from the `setup_data` function
which contains the transformed data}

\item{filter_replicates_target_col}{default is NULL; Which sample columns are
replicates whose variation you'd like to analyze; If NULL, the last 3 sample columns are used}

\item{wide_ar}{aspect ratio, default is 0.75}
}
\value{
a ggplot histogram
}
\description{
This function uses pivot_longer to rearrange the data for plotting,
 finds the variance for each pgRNA construct (using row number as a proxy) and then
 plots a histogram of these variances
}
\examples{
gimap_dataset <- get_example_data("gimap")
qc_variance_hist(gimap_dataset)


}
