% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_funcs.R
\name{determine.subgroups}
\alias{determine.subgroups}
\title{Determines subgroups.}
\usage{
determine.subgroups(data_list, base_syntax, n_subj, chisq_cutoff, file_order,
  elig_paths, confirm_subgroup, out_path = NULL)
}
\arguments{
\item{data_list}{A list of all datasets.}

\item{base_syntax}{A character vector containing syntax that never changes.}

\item{n_subj}{The number of subjects in the sample.}

\item{chisq_cutoff}{Cutoff used in order for MI to be considered significant.}

\item{file_order}{A data frame containing the order of the files and 
the names of the files. Used to merge in subgroup assignment and preserve
order.}

\item{elig_paths}{A character vector containing eligible paths that
gimme is allowed to add to the model. Ensures only EPCs from allowable paths
are considered in the creation of the similarity matrix.}

\item{confirm_subgroup}{A dataframe with the first column a string vector of data file names
without extensions and the second vector a integer vector of subgroup labels.}
}
\value{
Returns sub object containing similarity matrix, the number of
subgroups, the modularity associated with the subgroup memberships, 
and a data frame containing the file names and subgroup memberships.
}
\description{
Determines subgroups.
}
\keyword{internal}
