% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_class.R
\name{logLik.gips}
\alias{logLik.gips}
\title{Extract the Log-Likelihood for \code{gips} class}
\usage{
\method{logLik}{gips}(object, ...)
}
\arguments{
\item{object}{An object of class \code{gips}. Usually, a result of a \code{\link[=find_MAP]{find_MAP()}}.}

\item{...}{Further arguments will be ignored.}
}
\value{
Log-Likelihood of the sample.

When the multivariate normal model does not exist
(\code{number_of_observations < n0}), it returns \code{NULL}.
When the multivariate normal model cannot be reasonably approximated
(output of \code{\link[=project_matrix]{project_matrix()}} is singular), it returns \code{-Inf}.

In both failure situations, it shows a warning.
More information can be found in the \strong{Existence of likelihood} section below.
}
\description{
Calculates Log-Likelihood of the sample based on the \code{gips} object.
}
\details{
This will always be the biggest for \code{perm = "()"} (provided that \code{p <= n}).

If the found permutation still requires more parameters than \code{n},
the likelihood does not exist; thus the function returns \code{NULL}.

If the \code{projected_cov} (output of \code{\link[=project_matrix]{project_matrix()}})
is close to singular, the \code{NA} is returned.
}
\section{Existence of likelihood}{

We only consider the non-degenerate multivariate normal model.
In the \code{gips} context, such a model exists only when
the number of observations is bigger or equal to \code{n0}. To get \code{n0}
for the \code{gips} object \code{g}, call \code{summary(g)$n0}.

For more information, refer to \strong{\eqn{C_\sigma} and \code{n0}} section in
\code{vignette("Theory", package = "gips")} or its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}.
}

\section{Calculation details}{

For more details and used formulas, see
the \strong{Information Criterion - AIC and BIC} section in
\code{vignette("Theory", package = "gips")} or its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}.
}

\examples{
S <- matrix(c(
  5.15, 2.05, 3.60, 1.99,
  2.05, 5.09, 2.03, 3.57,
  3.60, 2.03, 5.21, 1.97,
  1.99, 3.57, 1.97, 5.13
), nrow = 4)
g <- gips(S, 5)
logLik(g) # -32.67048
# For perm = "()", which is default, there is p + choose(p, 2) degrees of freedom

g_map <- find_MAP(g, optimizer = "brute_force")
logLik(g_map) # -32.6722 # this will always be smaller than `logLik(gips(S, n, perm = ""))`

g_n_too_small <- gips(S, 4)
logLik(g_n_too_small) # NULL # the likelihood does not exists
}
\seealso{
\itemize{
\item \code{\link[=logLik]{logLik()}} - Generic function this \code{\link[=logLik.gips]{logLik.gips()}} extends.
\item \code{\link[=find_MAP]{find_MAP()}} - Usually, the \code{logLik.gips()}
is called on the output of \code{find_MAP()}.
\item \code{\link[=AIC.gips]{AIC.gips()}}, \code{\link[=BIC.gips]{BIC.gips()}} - Often, one is more
interested in an Information Criterion AIC or BIC.
\item \code{\link[=summary.gips]{summary.gips()}} - One can get \code{n0} by calling \code{summary(g)$n0}.
To see why one may be interested in \code{n0},
see the \strong{Existence of likelihood} section above.
\item \code{\link[=project_matrix]{project_matrix()}} - Project the known matrix
onto the found permutations space.
It is mentioned in the \strong{Calculation details} section above.
}
}
