% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.r
\docType{methods}
\name{show,git_merge_result-method}
\alias{show,git_merge_result-method}
\alias{show,git_merge_result-methods}
\title{Brief summary of merge result}
\usage{
\S4method{show}{git_merge_result}(object)
}
\arguments{
\item{object}{The \code{\linkS4class{git_merge_result}} \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of merge result
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("First line.",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create and checkout a new branch. Update 'example.txt' and commit
checkout(repo, "new_branch", create=TRUE)
writeLines(c("First line.", "Second line."),
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Second commit message")

## Checkout 'master' branch
checkout(repo, "master", force = TRUE)

## Display 'example.txt'
readLines(file.path(path, "example.txt"))

## Merge and display brief summary of the fast-forward merge
merge(repo, "new_branch")

## Display 'example.txt'
readLines(file.path(path, "example.txt"))
}
}
\keyword{methods}
