% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/config.r
\docType{methods}
\name{config}
\alias{config}
\alias{config,git_repository-method}
\title{Config}
\usage{
config(repo, user.name, user.email)

\S4method{config}{git_repository}(repo, user.name, user.email)
}
\arguments{
\item{repo}{the \code{repo} to configure}

\item{user.name}{the user name. Use NULL to delete the entry}

\item{user.email}{the e-mail address. Use NULL to delete the entry}
}
\value{
An invisible \code{list} with the configuration
}
\description{
Config file management. To display the configuration variables,
call method \code{config} with only the \code{repo} argument.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Set user name and email. The configuration is returned
cfg <-config(repo, user.name="Alice", user.email="alice@example.org")

## View configuration list
cfg

## Display configuration
config(repo)
}
}
\keyword{methods}

