% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_history.R
\name{git_history}
\alias{git_history}
\alias{git_get}
\title{Git Display History and Select Commit}
\usage{
git_history(path = ".", branch = NULL, top = 10, ...)

git_get(path = ".", branch = NULL, ...)
}
\arguments{
\item{path}{Only display / search commits which affect this path (dir or file)}

\item{branch}{Name of branch to display. If a match cannot be found with
git_get() in this branch, all branches are searched. Remote
branches can be viewed by using the format "origin/master"
providing that fetch or pull has downloaded changes.}

\item{top}{Maximum number of commits to display (post-filtering)}

\item{...}{Filters such as before='2021-01-01' or author='somebody'}
}
\value{
Return the git_commit object which best matches a wide variety of types. This
is used for git_diff() and git_checkout().

Vector of commit objects invisibly

Single commit object
}
\description{
Display the history of commits in a specific branch with the option to filter.
The list of commits is returned invisibly and can be extracted using \verb{[[i]]}
alternatively use \code{git_get()} to return the newest commit after filtering.
}
\details{
By default the history of the current branch is returned. The commits of a remote
branch can be found using \verb{branch='origin/master}, for example.

The following filter arguments can be given:
\itemize{
\item \code{n} - integer vector of commits back from latest (1 = most recent commit)
\item \code{hash} - character to match the beginning of commit hash
\item \code{before} and \code{after} - date object or string like '2021-01-31'
\item \code{message} - regular expression string to find in commit message
\item \code{author} and \code{email} - regular expression string of author or email of the commit
}

If nothing could be matched, \code{get_git()} will start looking on other branches,
for example when looking for a particular hash. The user is notified if this
happens.
}
