% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gitlab_api.R
\name{gitlab}
\alias{gitlab}
\title{Request Gitlab API}
\usage{
gitlab(req, api_root, verb = httr::GET, auto_format = TRUE, debug = FALSE,
  gitlab_con = "default", page = "all", enforce_api_root = TRUE, ...)
}
\arguments{
\item{req}{vector of characters that represents the call (e.g. \code{c("projects", project_id, "events")})}

\item{api_root}{URL where the gitlab API to request resides (e.g. \code{https://gitlab.myserver.com/api/v3/})}

\item{verb}{http verb to use for request in form of one of the \code{httr} functions
\code{\link[httr]{GET}}, \code{\link[httr]{PUT}}, \code{\link[httr]{POST}}, \code{\link[httr]{DELETE}}}

\item{auto_format}{whether to format the returned object automatically to a flat data.frame}

\item{debug}{if TRUE API URL and query will be printed, defaults to FALSE}

\item{gitlab_con}{function to use for issuing API requests (e.g. as returned by
\code{\link{gitlab_connection}}}

\item{page}{number of page of API response to get; if "all" (default), all pages are queried
successively and combined.}

\item{enforce_api_root}{if multiple pages are requested, the API root URL is ensured
to be the same as in the original call for all calls using the "next page" URL returned
by gitlab. This makes sense for security and in cases where gitlab is behind a reverse proxy
and ignorant about its URL from external.}

\item{...}{named parameters to pass on to gitlab API (technically: modifies query parameters of request URL),
may include private_token and all other parameters as documented for the Gitlab API}
}
\description{
Request Gitlab API
}

