targets::tar_test("tar_git_init() without .gitignore", {
  skip_os_git()
  store <- targets::tar_config_get("store")
  dir.create(store)
  expect_false(file.exists(file.path(store, ".git")))
  expect_false(file.exists(file.path(store, ".gitignore")))
  dir <- getwd()
  tar_git_init(store = store)
  expect_equal(getwd(), dir)
  expect_true(file.exists(file.path(store, ".git")))
  expect_false(file.exists(file.path(store, ".gitignore")))
})

targets::tar_test("tar_git_init() .gitattributes under vcs", {
  skip_os_git()
  store <- targets::tar_config_get("store")
  dir.create(store)
  expect_false(file.exists(file.path(store, ".gitattributes")))
  dir <- getwd()
  tar_git_init(store = store)
  expect_true(file.exists(file.path(store, ".gitattributes")))
  unlink(file.path(store, ".gitattributes"))
  status <- tar_git_status_data(store = store)
  expect_equal(status$file, ".gitattributes")
  expect_equal(status$status, "deleted")
  expect_equal(status$staged, FALSE)
})

targets::tar_test("tar_git_init() with git_lfs = FALSE", {
  skip_os_git()
  store <- targets::tar_config_get("store")
  dir.create(store)
  expect_false(file.exists(file.path(store, ".gitattributes")))
  dir <- getwd()
  tar_git_init(store = store, git_lfs = FALSE)
  expect_false(file.exists(file.path(store, ".gitattributes")))
})

targets::tar_test("tar_git_init() with .gitignore", {
  skip_os_git()
  store <- targets::tar_config_get("store")
  targets::tar_script(targets::tar_target(x, 1))
  targets::tar_make(callr_function = NULL)
  writeLines("*", file.path(store, ".gitignore"))
  expect_false(file.exists(file.path(store, ".git")))
  expect_true(file.exists(file.path(store, ".gitignore")))
  dir <- getwd()
  tar_git_init(store = store)
  expect_equal(getwd(), dir)
  expect_true(file.exists(file.path(store, ".git")))
  expect_true(file.exists(file.path(store, ".gitignore")))
})

targets::tar_test("tar_git_init() is idempotent", {
  skip_os_git()
  store <- targets::tar_config_get("store")
  dir.create(store)
  expect_false(file.exists(file.path(store, ".git")))
  expect_false(file.exists(file.path(store, ".gitignore")))
  dir <- getwd()
  tar_git_init(store = store)
  tar_git_init(store = store)
  expect_equal(getwd(), dir)
  expect_true(file.exists(file.path(store, ".git")))
  expect_false(file.exists(file.path(store, ".gitignore")))
})
