% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcn.R
\name{tune_network}
\alias{tune_network}
\title{tune two network}
\usage{
tune_network(y, x, L1, L2, adaptl2 = T, nfolds = 5, cvwhich, foldseed,
  stratify = T, lam0, bets, intercept = T, standardize = T,
  fam = "Gaussian", type1se = T, measdev = T, maxiter = 10000,
  cri = 0.001, parallel = F)
}
\arguments{
\item{y}{outcome}

\item{x}{predictors matrix}

\item{L1}{Laplacian matrix for the first network}

\item{L2}{Laplacian matrix for the second network}

\item{adaptl2}{whether to adapt the sign for quadratic penalty, default to be TRUE}

\item{nfolds}{number of folds used in cross validation, default to be five}

\item{cvwhich}{fold assignment, start from zero, if missing do random cross validation}

\item{foldseed}{the random seed for cross validation design}

\item{stratify}{whether to do stratified cross validation for Logistic or Cox model, default to be TRUE}

\item{lam0}{The tuning parameters for quadratic penalty. If not defined, tuned by default}

\item{bets}{The candidate weight for the first network, must be between 0 and 1, default to be 0, 0.1,..., 1}

\item{intercept}{whether to include intercept. Ignore for Cox regression}

\item{standardize}{whether to standardize predictors}

\item{fam}{family for the outcome, can be "Gaussian", "Logistic", and "Cox"}

\item{type1se}{whether to use one standard error or maximum rule, default to be one standard error rule}

\item{measdev}{Whether to use deviance to tune, default to be deviance. If not, use mean absolue error, area under ROC curve, or concordance index for Gaussian, Logistic, and Cox}

\item{maxiter}{maximum number of iterations, default to be 500}

\item{cri}{stoppint criterion, default to be 0.001}

\item{parallel}{whether to do parallel computing at each fold}
}
\value{
\item{est}{estimated mixed Laplacian matrix}

\item{weight}{weights for the two Laplacian matrix}
}
\description{
Tune two network for better prediction.
}
\examples{
data(sampledata)
data(L0)
data(L1)
y <- sampledata$Y_Gau
x <- sampledata[, -(1:3)]
Ltune <- tune_network(y, x, L0, L1, adaptl2 = FALSE)
weight <- Ltune@weight
Lest <- Ltune@est
}
