% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{estimate_confint_contrast}
\alias{estimate_confint_contrast}
\title{Computes point estimates, confidence intervals and P-values of a contrast}
\usage{
estimate_confint_contrast(
  model,
  contrast,
  method = NULL,
  level = 0.95,
  force = FALSE,
  debuglevel = 1,
  H0 = 0,
  alternative = c("two.sided", "less", "greater"),
  ...
)
}
\arguments{
\item{model}{a fitted statistical model such as a glm or a coxph.}

\item{contrast}{numeric vector of the same length as the number of coefficients in the model; it describes the contrast \code{sum(contrast*fixcoef(model))}.}

\item{method}{character string value; specification of the algorithm used (implementation dependent). NULL must be accepted. The default method is "Wald".
With the default \code{confint_contrast} and \code{p_value_contrast}, the only supported values are: "Wald", "wald" and "SlowWald".
All three are equivalent but "SlowWald" is slower and is used for debug purpose only. If \code{confint_contrast} and \code{p_value_contrast} are
specialized, they may provide other methods.}

\item{level}{numeric value between 0 and 1; nominal two-sided confidence level of the confidence interval.}

\item{force}{logical; if TRUE, force computation of P-values in case of convergence problems.}

\item{debuglevel}{integer value; set to 0 (default) to disable warnings, 1 to enable warnings and 2 to enable warnings and notes.}

\item{H0}{numeric value; the value of the contrast under the null hypothesis.}

\item{alternative}{a character string specifying the alternative hypothesis,}

\item{...}{Additional parameters that may be used by some implementations.}
}
\description{
This function combines outputs from \code{\link{estimate_contrast}}, \code{\link{confint_contrast}} and \code{\link{p_value_contrast}} 
to provide a 4-values vector with point estimate (1st value), lower and upper boundaries of the confidence interval (2nd and 3rd values)
and P-value (4th value) comparing the contrast to \code{H0}.
}
\details{
When alternative is "less" or  "greater", a one-sided confidence interval and a one-sided P-value are generated.
If H0 is not zero, the P-value compares the estimate to the value of H0, but the estimate and confidence interval are unchanged.
}
\examples{
data(mtcars)
model1 = glm(family="gaussian", data=mtcars, hp ~ 0+factor(gear))
# do cars with 5 gears have more horse power (hp) than cars with 4 gears ?
estimate_confint_contrast(model1, c(0,-1,1))

# now, we fit an equivalent model (same distribution and same predictions)
model2 = glm(family=gaussian(log), data=mtcars, hp ~ 0+factor(gear))

# do cars with 5 gears have at least twice the horse power than cars with 4 gears ?

estimate_confint_contrast(model2, c(0,-1,0.5))
}
\seealso{
Other Contrast functions: 
\code{\link{confint_contrast}()},
\code{\link{estimate_contrast}()},
\code{\link{p_value_contrast}()}
}
\concept{Contrast functions}
