% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmSeq.R
\name{glmerApply}
\alias{glmerApply}
\title{Fit a glmer model for an individual gene}
\usage{
glmerApply(
  geneList,
  fullFormula,
  data,
  control,
  modelData,
  designMatrix,
  offset,
  ...
)
}
\arguments{
\item{geneList}{List with gene expression and dispersion}

\item{fullFormula}{the model formula. For more information of formula
structure see \code{\link[lme4:glmer]{lme4::glmer()}}}

\item{data}{The sample data or metadata.}

\item{control}{the glmer control (default=glmerControl(optimizer="bobyqa")).
For more information see
\code{\link[lme4:glmerControl]{lme4::glmerControl()}}.}

\item{modelData}{Expanded design matrix}

\item{designMatrix}{The design matrix}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. For more information see
\code{\link[lme4:glmer]{lme4::glmer()}}.}

\item{...}{Other parameters to pass to
\code{\link[lme4:glmer]{lme4::glmer()}}}
}
\value{
Returns a GlmmSeq object with results for gene-wise general linear
mixed models
}
\description{
Fit a glmer model for an individual gene
}
\keyword{internal}
