% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_ci.R
\name{bootstrap_ci}
\alias{bootstrap_ci}
\title{Generating bootstrap confidence intervals.}
\usage{
bootstrap_ci(
  base_coef_se = NULL,
  resampled_coef_se = NULL,
  orig_df = NULL,
  alpha_level = 0.05,
  probs = NULL
)
}
\arguments{
\item{base_coef_se}{Estimates and SEs from full sample. In matrix form,
i.e. a \eqn{(p+1) x 2} matrix, first column is estimates,
second is standard errors. This is the output from using:
\code{coef(summary(model_output))[,1:2, drop = FALSE]}
or
\code{coef(summary(model_output))$cond[,1:2, drop = FALSE]}
if \code{model_output} is the output from a random
effects model (some may not have \code{cond} as the correct pull).}

\item{resampled_coef_se}{List of estimates and SEs from the bootstrapped
resamples, each list entry has the same format as the base_coef_se above.}

\item{orig_df}{Degrees of freedom to use to calculate the
t-values used for the base interval.}

\item{alpha_level}{level of CI - if you fill in \code{probs}, will use those instead}

\item{probs}{Default \code{NULL}, and will use \code{alpha_level} to set
endpoints. Else will calculate these CI endpoints.}
}
\value{
A matrix containing:
  \itemize{
   \item Estimates
   \item Bootstrap interval endpoints
   \item Bootstrap p-value
   \item Base p-value
   \item Base interval endpoints
   \item Relative width of bootstrap interval to base
  }
}
\description{
Enter first level estimates and second level estimates,
get bootstrap interval, from the pivotal bootstrap t
(Efron and Tibshirani 1994, also endorsed
by Hesterberg 2015).
}
\examples{
x <- rnorm(20)
y <- rnorm(20) + x
xy_data = data.frame(x = x, y = y)
first_model <- lm(y ~ x, data = xy_data)
out_list <- bootstrap_model(first_model, base_data = xy_data, 20,
                           return_coefs_instead = TRUE)
bootstrap_ci(out_list$base_coef_se,
             out_list$resampled_coef_se)

\donttest{
  data(test_data)
  library(glmmTMB)
  ## where subj is a random effect
  test_model <- glmmTMB(y ~ x_var1 + (1 | subj),
                        data = test_data, family = binomial)
  output_lists <- bootstrap_model(test_model, base_data = test_data, 199,
                                  return_coefs_instead = TRUE)
  bootstrap_ci(output_lists$base_coef_se,
               output_lists$resampled_coef_se)
}

}
