# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generates the covariance matrix of the random effects
#' 
#' Generates the covariance matrix of the random effects from a sparse representation. Used internally in the Covariance class.
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector of parameters used to generate the matrix D. 
#' @return A symmetric positive definite covariance matrix
genD <- function(cov, data, eff_range, gamma) {
    .Call(`_glmmrBase_genD`, cov, data, eff_range, gamma)
}

#' Generates the Cholesky decomposition covariance matrix of the random effects
#' 
#' Generates the Cholesky Decomposition of the covariance matrix of the random effects. Used internally in the Covariance class.
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of varaibles
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector of parameters used to generate the matrix D. 
#' @return A lower triangular matrix
genCholD <- function(cov, data, eff_range, gamma) {
    .Call(`_glmmrBase_genCholD`, cov, data, eff_range, gamma)
}

#' Generates a sample of random effects
#' 
#' Generates a sample of random effects from the specified covariance matrix.
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of varaibles
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector of parameters used to generate the matrix D. 
#' @return A lower triangular matrix
sample_re <- function(cov, data, eff_range, gamma) {
    .Call(`_glmmrBase_sample_re`, cov, data, eff_range, gamma)
}

#' Generates the inverse GLM iterated weights.
#' 
#' @param xb Vector with mean function value evaluated at fitted model parameters
#' @param family String declaring model family
#' @param link String declaring model link function
#' @return Vector of derivative values
gen_dhdmu <- function(xb, family, link) {
    .Call(`_glmmrBase_gen_dhdmu`, xb, family, link)
}

#' Generates an approximation to the covariance of y
#' 
#' Generates a first-order approximation to the covariance matrix 
#' of y based on the marginal quasi-likelihood. This approximation is
#' exact for the Gaussian-identity model. Used internally by the \link[glmmrBase]{Model} class.
#' @param xb Vector of values of the linear predictor
#' @param Z Random effects design matrix
#' @param D Covariance matrix of the random effects
#' @param family String specifying the family
#' @param link String specifying the link function
#' @param var_par Value of the optional scale parameter
#' @param attenuate Logical indicating whether to use "attenuated" values of the linear predictor
#' @param qlik Not used.
#' @return A matrix
gen_sigma_approx <- function(xb, Z, D, family, link, var_par, attenuate, qlik = TRUE) {
    .Call(`_glmmrBase_gen_sigma_approx`, xb, Z, D, family, link, var_par, attenuate, qlik)
}

#' Return marginal expectation with attenuation
#' 
#' The marginal expectation may be better approximated using an attenuation 
#' scheme in non-linear models. This function returns the attenuated linear predictor.
#' Used internally.
#' @param xb Vector of values of the linear predictor
#' @param Z Random effects design matrix
#' @param D Covariance matrix of the random effects
#' @param link String specifying the link function
#' @return A vector
attenuate_xb <- function(xb, Z, D, link) {
    .Call(`_glmmrBase_attenuate_xb`, xb, Z, D, link)
}

