% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{confint.gnm}
\alias{confint.gnm}
\title{Confidence Intervals for Generalized Nonlinear Models}
\usage{
\method{confint}{gnm}(
  object,
  parm,
  level = 0.95,
  contrast,
  digits = max(3, getOption("digits") - 2),
  dispersion = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of the class \emph{gnm}.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{an (optional) value indicating the required confidence level. As default, \code{level} is set to 0.95.}

\item{contrast}{an (optional) matrix indicating the linear combinations of parameters for which confidence intervals are required. The number of rows in this matrix corresponds to the number of linear combinations required.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used. As default, \code{digits} is set to \code{max(3, getOption("digits") - 2)}.}

\item{dispersion}{an (optional) value indicating the estimate of the dispersion parameter. As default, \code{dispersion} is set to \code{summary(object)$dispersion}.}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. As default, \code{verbose} is set to TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with so many rows as parameters in the "linear" predictor and two columns: "Lower limit" and "Upper limit".
}
\description{
Computes confidence intervals based on Wald test for a generalized nonlinear model.
}
\details{
The approximate 100(\code{level})\% confidence interval for \eqn{\beta} based on the Wald test.
}
\examples{
###### Example 1: The effects of fertilizers on coastal Bermuda grass
data(Grass)
fit1 <- gnm(Yield ~ b0 + b1/(Nitrogen + a1) + b2/(Phosphorus + a2) + b3/(Potassium + a3),
            family=gaussian(inverse), start=c(b0=0.1,b1=13,b2=1,b3=1,a1=45,a2=15,a3=30), data=Grass)

confint(fit1, level=0.95)

###### Example 2: Assay of an Insecticide with a Synergist
data(Melanopus)
fit2 <- gnm(Killed/Exposed ~ b0 + b1*log(Insecticide-a1) + b2*Synergist/(a2 + Synergist),
            family=binomial(logit), weights=Exposed, start=c(b0=-3,b1=1.2,a1=1.7,b2=1.7,a2=2),
		   data=Melanopus)

confint(fit2, level=0.95)

###### Example 3: Developmental rate of Drosophila melanogaster
data(Drosophila)
fit3 <- gnm(Duration ~ b0 + b1*Temp + b2/(Temp-a), family=Gamma(log),
            start=c(b0=3,b1=-0.25,b2=-210,a=55), weights=Size, data=Drosophila)

confint(fit3, level=0.95)

###### Example 4: Radioimmunological Assay of Cortisol
data(Cortisol)
fit4 <- gnm(Y ~ b0 + (b1-b0)/(1 + exp(b2+ b3*lDose))^b4, family=Gamma(identity),
            start=c(b0=130,b1=2800,b2=3,b3=3,b4=0.5), data=Cortisol)

### Confidence Interval for 'b1-b0'
confint(fit4, level=0.95, contrast=matrix(c(-1,1,0,0,0),1,5))

### Confidence Intervals for 'b0', 'b1', 'b2', 'b3', 'b4'
confint(fit4, level=0.95, contrast=diag(5))

}
