% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_locations.r
\name{add_locations}
\alias{add_locations}
\title{Add sets of locations}
\usage{
add_locations(locations, type, export = TRUE)
}
\arguments{
\item{locations}{Locations that should be added as set of locations. Vector of
type \code{character}.}

\item{type}{Name of the location set that should be added. Object of type
\code{character} of length 1.}

\item{export}{Indicator whether the new location set should be directly
exported to the package environment \code{gt.env}. Object of type \code{logical},
defaults to \code{TRUE}.}
}
\value{
Message that the location set has been created successfully. Location data is
written to table \emph{data_locations}.
}
\description{
The function adds a new set of locations for downloads and computations to
the database. The location set serves as input for all download and
computation functions.
}
\details{
Location sets control the locations for which data is downloaded or to which
computations are applied. By adding new location sets, the default sets
\emph{countries} and \emph{us_states} can be expanded by additional sets.
Thereby, users can compute DOI within a region (e.g., adding EU countries as
a set) or single countries (e.g., adding regions of France as a set). Download
and computation functions check whether data for a location already exists.
Therefore, data will not be duplicated when location data already exists from
another set.
}
\examples{
\dontrun{
add_locations(locations = c("AT", "CH", "DE"), type = "DACH")
}
}
