% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{batch_time}
\alias{batch_time}
\alias{example_time}
\title{batch_time}
\format{
A tibble with 5 rows and 3 variables:
\describe{
\item{type}{Column of type \code{character} showing the type of each batch,
takes "control" for control batches and "object" for object batches.}
\item{batch}{Column of type \code{integer} showing number of each batch.}
\item{time}{Column of type \code{character} showing the time period for
each batch as "YYYY-MM-DD YYYY-MM-DD".}
}
}
\usage{
example_time
}
\description{
The table \emph{batch_time} contains the time period for which data is
downloaded for each batch. Each line contains one \emph{time} period, the
\emph{type} of the batch (i.e., control or object) and the id of the
\emph{batch} to which the time period is assigned. Time frames take the form
\code{"YYYY-MM-DD YYYY-MM-DD"}. Time periods are added automatically through
the function \code{add_keywords}. The function \code{start_db} exports the
table \emph{batch_time} as objects \code{time_control} and \code{time_object}
to \code{.GlobalEnv}.

Example data for the table \emph{batch_time} is available as R object
\code{example_time}.
}
\seealso{
\itemize{
\item \code{\link[=add_control_keyword]{add_control_keyword()}}
}
}
\keyword{datasets}
