% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_box.r
\name{plot_box}
\alias{plot_box}
\alias{plot_box.exp_score}
\alias{plot_box.abnorm_score}
\alias{plot_box.exp_voi}
\alias{plot_box.abnorm_voi}
\alias{plot_box.exp_doi}
\alias{plot_box.abnorm_doi}
\title{Create boxplot for time series of globaltrends data}
\usage{
plot_box(data, ...)

\method{plot_box}{exp_score}(data, type = c("obs", "sad", "trd"), ...)

\method{plot_box}{abnorm_score}(data, ci = 0.95, ...)

\method{plot_box}{exp_voi}(data, type = c("obs", "sad", "trd"), ...)

\method{plot_box}{abnorm_voi}(data, ci = 0.95, ...)

\method{plot_box}{exp_doi}(
  data,
  type = c("obs", "sad", "trd"),
  measure = c("gini", "hhi", "entropy"),
  locations = "countries",
  ...
)

\method{plot_box}{abnorm_doi}(
  data,
  type = c("obs", "sad", "trd"),
  locations = "countries",
  ci = 0.95,
  ...
)
}
\arguments{
\item{data}{Data exported from \code{export_...} or \code{compute_abnorm} functions.}

\item{...}{Further arguments passed to or from other methods.}

\item{type}{Object of type \code{character} indicating the type of time
series-column from data_score, takes either \emph{obs}, \emph{sad}, or \emph{trd}. Defaults
to \emph{"obs"}.}

\item{ci}{Confidence interval within which changes are assumed to be normal.
Object of type \verb{double, 0 < ci < 1}. Defaults to \emph{0.95}.}

\item{measure}{Object of type \code{character} indicating the DOI measure,
takes either \emph{gini}, \emph{hhi}, or \emph{entropy}. Defaults to \emph{"gini"}.}

\item{locations}{Object of type \code{character} indicating for which
set of locations should be filtered. Defaults to \emph{"countries"}.}
}
\value{
Boxplot of time series as \code{ggplot2} object. For plots for output from
\code{get_abnorm_hist} the provided confidence interval is indicated by red dots.
}
\description{
The function creates boxplots for time series globaltrends data. It uses
the output of \code{export_...} or \code{get_abnorm_hist} to prepare boxplots for up to
nine keywords.
}
\details{
For output of \code{export_score}, only data for a single location is shown.
When date for more than one location is provided, the function selects only
the first location.
For output of \code{get_abnorm_hist}, users can specify confidence intervals
to highlight abnormal changes in the data.
}
\examples{
\dontrun{
data <- export_score(keyword = "amazon")
plot_box(data, type = "obs")

data <- export_voi(keyword = "amazon")
data <- get_abnorm_hist(data, train_win = 12, train_break = 0, type = "obs")
plot_box(data)

data <- export_doi(keyword = "amazon")
data <- get_abnorm_hist(data, train_win = 12, train_break = 0, measure = "gini")
plot_box(data, ci = 0.9)
}

}
