% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe.R
\name{glue_safe}
\alias{glue_safe}
\alias{glue_data_safe}
\title{Safely interpolate strings}
\usage{
glue_safe(..., .envir = parent.frame())

glue_data_safe(.x, ..., .envir = parent.frame())
}
\arguments{
\item{...}{[\code{expressions}]\cr Unnamed arguments are taken to be expressions
string(s) to format. Multiple inputs are concatenated together before formatting.
Named arguments are taken to be temporary variables available for substitution.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored. If \code{NULL} is passed it is equivalent to \code{\link[=emptyenv]{emptyenv()}}.}

\item{.x}{[\code{listish}]\cr An environment, list or data frame used to lookup values.}
}
\description{
\code{glue_safe()} and \code{glue_data_safe()} differ from \code{glue()} and \code{glue_data()}
in that the safe versions only look up symbols from an environment use
\code{\link[=get]{get()}} they do not execute any R code. This makes them suitable when used
with untrusted input, such as inputs in a shiny application, where using the
normal functions would allow an attacker to execute arbitrary code.
}
