% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glyco.outliers.R
\name{glyco.outliers}
\alias{glyco.outliers}
\title{Discover outliers in glycan data}
\usage{
glyco.outliers(data, group = NULL, outlier.function = NULL, alpha = 1.5)
}
\arguments{
\item{data}{data frame in long format containing glycan measurements}

\item{group}{a possible grouping parameter on which
stratification of \code{data} should be conducted. It should be
a name of one of the columns in dataframe \code{data}
and of type \code{factor}.}

\item{outlier.function}{a function that checks for outliers in
a vector. Receives one parameter representing a vector and returns
logical vector indicating outliers.}

\item{alpha}{If outlier.function parameter is set to NULL
outliers are calculated as those points that are greater
than upper quartile + alpha * IQR (interquartile range) or
lower than lower quartile - alpha * IQR (interquartile range).
If parameter outlier.function is not NULL parameter alpha is not used.}
}
\value{
Returns a data.frame with outliers
}
\description{
Returns outliers within every glycan structure
}
\details{
Input data frame should have at least the following three columns: \cr
  - gid - representing a unique name of a sample \cr
  - glycan - representing glycan names \cr
  - value - representing measured values
}
\examples{
data(mpiu)

glyco.outliers(mpiu)

# outliers per plate
glyco.outliers(mpiu, group="Plate")
}
\author{
Ivo Ugrina
}

